/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eolang.AtAbsent;
import org.eolang.AtFixed;
import org.eolang.AtNamed;
import org.eolang.AtPhiSensitive;
import org.eolang.AtSafe;
import org.eolang.AtSimple;
import org.eolang.Attr;
import org.eolang.CachedPhi;
import org.eolang.Data;
import org.eolang.ExFailure;
import org.eolang.Indented;
import org.eolang.Phi;
import org.eolang.Versionized;
import org.eolang.Vertices;
import org.eolang.Volatile;
import org.eolang.XmirObject;

@Versionized
public abstract class PhDefault
implements Phi,
Cloneable {
    protected static final Vertices VTX = new Vertices();
    private static final Logger LOGGER = Logger.getLogger(PhDefault.class.getName());
    private static final Pattern SORTABLE = Pattern.compile("^[a-z].*$");
    private static final ThreadLocal<Set<Integer>> TERMS = new ThreadLocal();
    private static final ThreadLocal<Integer> NESTING = ThreadLocal.withInitial(() -> 0);
    protected int vertex;
    private String form;
    private final List<String> order;
    private Map<String, Attr> attrs;
    private CachedPhi cached = new CachedPhi();

    public PhDefault() {
        this(Phi.\u03a6);
    }

    public PhDefault(Phi sigma) {
        this.vertex = VTX.next();
        this.form = this.getClass().getName();
        this.attrs = new HashMap<String, Attr>(0);
        this.order = new ArrayList<String>(0);
        this.add("\u03c1", new AtSimple(sigma));
        this.add("\u03c3", new AtFixed(new AtSimple(sigma)));
    }

    public boolean equals(Object obj) {
        return obj instanceof Phi && this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return this.vertex;
    }

    @Override
    public String \u03c6Term() {
        String txt;
        if (null == TERMS.get()) {
            TERMS.set(new HashSet());
        }
        if (TERMS.get().contains(this.vertex)) {
            txt = String.format("\u03bd%d", this.vertex);
        } else {
            TERMS.get().add(this.vertex);
            ArrayList<String> list = new ArrayList<String>(this.attrs.size());
            for (Map.Entry ent : this.attrs.entrySet().stream().filter(e -> Arrays.asList("\u03c3", "\u03c1", "\u0394").contains(e.getKey())).collect(Collectors.toList())) {
                String attr = String.format("%s \u21a6 %s", ent.getKey(), ((Attr)ent.getValue()).\u03c6Term());
                list.add(attr);
            }
            TERMS.get().remove(this.vertex);
            Collections.sort(list);
            txt = this.oname();
            if (!list.isEmpty()) {
                txt = String.format("\u03bd%d\u00b7%s\u27e6\n\t%s\n\u27e7", this.vertex, txt, new Indented(String.join((CharSequence)",\n", list)));
            }
        }
        return txt;
    }

    public String toString() {
        String result = String.format("%s\u03bd%d", this.getClass().getCanonicalName(), this.vertex);
        if (this.attrs.containsKey("\u0394")) {
            result = String.format("%s=%s", result, this.attrs.get("\u0394").toString());
        }
        return result;
    }

    @Override
    public final Phi copy() {
        try {
            PhDefault copy = (PhDefault)this.clone();
            copy.vertex = VTX.next();
            copy.form = this.form;
            copy.cached = new CachedPhi();
            HashMap<String, Attr> map = new HashMap<String, Attr>(this.attrs.size());
            for (Map.Entry<String, Attr> ent : this.attrs.entrySet()) {
                map.put(ent.getKey(), ent.getValue().copy(copy));
            }
            copy.attrs = map;
            return copy;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public final Attr attr(int pos) {
        if (0 > pos) {
            throw new ExFailure(String.format("Attribute position can't be negative (%d)", pos), new Object[0]);
        }
        if (this.order.isEmpty()) {
            throw new ExFailure(String.format("There are no attributes here, can't read the %d-th one", pos), new Object[0]);
        }
        Attr attr = this.attr(this.order.get(0));
        for (int idx = 0; idx <= pos; ++idx) {
            if (idx >= this.order.size()) {
                throw new ExFailure(String.format("%s has just %d attribute(s), can't read the %d-th one", this, this.order.size(), pos), new Object[0]);
            }
            attr = this.attr(this.order.get(idx));
        }
        return attr;
    }

    @Override
    public final Attr attr(String name) {
        NESTING.set(NESTING.get() + 1);
        Attr attr = "\u03bd".equals(name) ? new AtSimple(new Data.ToPhi(this.hashCode())) : this.attrs.get(name);
        if (null == attr) {
            String through = this.attrs.containsKey("\u03c6") ? "\u03c6" : "\u03bb";
            Attr aphi = this.attrs.get(through);
            if (null == aphi) {
                attr = new AtAbsent(name, String.format(" among other %d attrs (%s) and %s is absent", this.attrs.size(), String.join((CharSequence)", ", this.attrs.keySet()), through));
            } else {
                Phi phi = this.cached.get(name, aphi::get);
                Phi found = phi.attr(name).get();
                found.attr("\u03c1").put(this);
                attr = new AtSimple(found);
            }
        }
        attr = this.named(attr, name);
        if ("\u03c6".equals(name)) {
            attr = new AtPhiSensitive(attr, this.cached);
        }
        if (this.getClass().isAnnotationPresent(Volatile.class)) {
            this.cached.reset();
        }
        attr = new AtSafe(attr);
        PhDefault.debug(String.format("%s\ud835\udd38('%s' for %s) \u279c %s", PhDefault.padding(), name, this, attr));
        NESTING.set(NESTING.get() - 1);
        return attr;
    }

    @Override
    public String locator() {
        return "?";
    }

    @Override
    public String forma() {
        return this.form;
    }

    public static void cleanUp() {
        TERMS.remove();
        NESTING.remove();
    }

    protected final void add(String name, Attr attr) {
        if (SORTABLE.matcher(name).matches()) {
            this.order.add(name);
        }
        this.attrs.put(name, attr);
    }

    private Attr named(Attr attr, String name) {
        return new AtNamed(String.format("%s#%s", this.getClass().getCanonicalName(), name), String.format("%s.%s", this.oname(), name), this, attr);
    }

    private String oname() {
        String txt = this.getClass().getSimpleName();
        XmirObject xmir = this.getClass().getAnnotation(XmirObject.class);
        if (null != xmir && "@".equals(txt = xmir.oname())) {
            txt = "\u03c6";
        }
        return txt;
    }

    private static void debug(String msg) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, msg);
        }
    }

    private static String padding() {
        return String.join((CharSequence)"", Collections.nCopies(NESTING.get(), "\u00b7"));
    }
}

