/*
 * Decompiled with CFR 0.152.
 */
package EOorg.EOeolang;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eolang.AtFree;
import org.eolang.AtLambda;
import org.eolang.Data;
import org.eolang.ExFailure;
import org.eolang.ExNative;
import org.eolang.PhDefault;
import org.eolang.Phi;
import org.eolang.Universe;
import org.eolang.UniverseDefault;
import org.eolang.UniverseSafe;
import org.eolang.Versionized;
import org.eolang.XmirObject;

@XmirObject(oname="rust")
@Versionized
public class EOrust
extends PhDefault {
    private static final ConcurrentHashMap<String, String> NAMES;
    private final Map<Integer, Phi> phis = new HashMap<Integer, Phi>();
    private final AtomicReference<Throwable> error = new AtomicReference();

    public EOrust(Phi sigma) {
        super(sigma);
        this.add("code", new AtFree());
        this.add("portal", new AtFree());
        this.add("params", new AtFree());
        this.add("\u03bb", new AtLambda(this, rho -> {
            String name = NAMES.get(rho.attr("code").get().locator().split(":")[0]);
            Method method = Class.forName(String.format("EOrust.natives.%s", name)).getDeclaredMethod(name, Universe.class);
            if (method.getReturnType() != byte[].class) {
                throw new ExFailure("Return type of %s is %s, required %s", method, method.getReturnType(), byte[].class);
            }
            Phi portal = rho.attr("portal").get();
            return this.translate((byte[])method.invoke(null, new UniverseSafe(new UniverseDefault(portal, this.phis), this.error)), rho.attr("code").get().locator());
        }));
    }

    private static ConcurrentHashMap<String, String> load(String src) throws IOException {
        ConcurrentHashMap concurrentHashMap;
        ObjectInputStream map = new ObjectInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(Files.readAllBytes(Paths.get(src, new String[0])))));
        try {
            Object result = map.readObject();
            if (result.getClass() != ConcurrentHashMap.class) {
                throw new ClassCastException(String.format("Object inside %s has wrong class %s", src, result.getClass()));
            }
            concurrentHashMap = (ConcurrentHashMap)result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    map.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException exc) {
                throw new IllegalArgumentException(String.format("File %s contains invalid data", src), exc);
            }
        }
        map.close();
        return concurrentHashMap;
    }

    private Phi translate(byte[] message, String insert) {
        Phi ret;
        byte determinant = message[0];
        byte[] content = Arrays.copyOfRange(message, 1, message.length);
        switch (determinant) {
            case 0: {
                ByteBuffer buffer = ByteBuffer.allocate(4);
                buffer.put(content);
                buffer.flip();
                int vertex = buffer.getInt();
                ret = this.phis.get(vertex);
                if (ret != null) break;
                throw new ExFailure(String.format("Returned phi with vertex %d (%s in bytes) was not indexed", vertex, Arrays.toString(content)), new Object[0]);
            }
            case 1: {
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.put(content);
                buffer.flip();
                ret = new Data.ToPhi(buffer.getDouble());
                break;
            }
            case 2: {
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.put(content);
                buffer.flip();
                ret = new Data.ToPhi(buffer.getLong());
                break;
            }
            case 4: {
                ret = new Data.ToPhi(content);
                break;
            }
            case 3: {
                ret = new Data.ToPhi(new String(content, StandardCharsets.UTF_8));
                break;
            }
            case 5: {
                String cause = new String(content, StandardCharsets.UTF_8);
                if (this.error.get() == null) {
                    throw new ExNative("Rust insert failed in %s with message '%s'", insert, cause);
                }
                throw new ExNative(String.format("Rust insert failed in %s with message '%s'", insert, cause), this.error.get());
            }
            default: {
                throw new ExNative("Returning Strings and raw bytes is not implemented yet, insert %s", insert);
            }
        }
        return ret;
    }

    static {
        String lib;
        try {
            NAMES = EOrust.load("target/names");
        }
        catch (IOException exc) {
            throw new ExFailure("Cannot read the file target/eo-test/names", exc);
        }
        String system = System.getProperty("os.name").toLowerCase();
        if (system.contains("win")) {
            lib = "common.dll";
        } else if (system.contains("nix") || system.contains("nux") || system.contains("aix")) {
            lib = "libcommon.so";
        } else if (system.contains("mac")) {
            lib = "libcommon.dylib";
        } else {
            throw new UnsupportedOperationException(String.format("Rust inserts are not supported by %s os. Only windows, linux and macos are allowed.", System.getProperty("os.name")));
        }
        File libs = Paths.get("target", new String[0]).resolve("eo-test").resolve("Lib").toFile();
        if (libs.isDirectory()) {
            for (File subdir : libs.listFiles()) {
                Path path = subdir.toPath().resolve("target").resolve("debug").resolve(lib).toAbsolutePath();
                if (!path.toFile().exists()) continue;
                System.load(path.toString());
            }
        }
    }
}

