/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.util.concurrent.atomic.AtomicReference;
import org.eolang.Universe;
import org.eolang.UniverseDefault;
import org.eolang.Versionized;

@Versionized
public final class UniverseSafe
implements Universe {
    private final UniverseDefault origin;
    private final AtomicReference<Throwable> saved;

    public UniverseSafe(UniverseDefault origin, AtomicReference<Throwable> throwable) {
        this.origin = origin;
        this.saved = throwable;
    }

    @Override
    public int find(String name) {
        try {
            return this.origin.find(name);
        }
        catch (Throwable throwable) {
            this.saved.set(throwable);
            throw throwable;
        }
    }

    @Override
    public void put(int vertex, byte[] bytes) {
        try {
            this.origin.put(vertex, bytes);
        }
        catch (Throwable throwable) {
            this.saved.set(throwable);
            throw throwable;
        }
    }

    @Override
    public void bind(int parent, int child, String att) {
        try {
            this.origin.bind(parent, child, att);
        }
        catch (Throwable throwable) {
            this.saved.set(throwable);
            throw throwable;
        }
    }

    @Override
    public int copy(int vertex) {
        try {
            return this.origin.copy(vertex);
        }
        catch (Throwable throwable) {
            this.saved.set(throwable);
            throw throwable;
        }
    }

    @Override
    public byte[] dataize(int vertex) {
        try {
            return this.origin.dataize(vertex);
        }
        catch (Throwable throwable) {
            this.saved.set(throwable);
            throw throwable;
        }
    }
}

