/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eolang.Data;
import org.eolang.ExFailure;
import org.eolang.Param;
import org.eolang.Phi;
import org.eolang.Universe;
import org.eolang.Versionized;

@Versionized
public final class UniverseDefault
implements Universe {
    private final Phi connector;
    private final Map<Integer, Phi> indexed;

    public UniverseDefault(Phi connector, Map<Integer, Phi> indexed) {
        this.connector = connector;
        this.indexed = indexed;
    }

    public UniverseDefault(Phi connector) {
        this(connector, new HashMap<Integer, Phi>());
    }

    public UniverseDefault() {
        this(Phi.\u03a6);
    }

    @Override
    public int find(String name) {
        Phi accum;
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null");
        }
        String[] atts = UniverseDefault.replace(name).split("\\.");
        if ("Q".equals(atts[0])) {
            accum = Phi.\u03a6;
        } else if ("$".equals(atts[0])) {
            accum = this.connector;
        } else {
            throw new ExFailure(String.format("Universe.find starts with %s, but it should start with Q or $ only", atts[0]), new Object[0]);
        }
        atts[0] = "";
        for (String att : atts) {
            if ("".equals(att)) continue;
            accum = accum.attr(att).get();
        }
        this.indexed.putIfAbsent(accum.hashCode(), accum);
        return accum.hashCode();
    }

    @Override
    public void put(int vertex, byte[] bytes) {
        this.get(vertex).attr("\u0394").put(new Data.Value<byte[]>(bytes));
    }

    @Override
    public void bind(int parent, int child, String att) {
        this.get(parent).attr(att).put(this.get(child));
    }

    @Override
    public int copy(int vertex) {
        Phi copy = this.get(vertex).copy();
        this.indexed.putIfAbsent(copy.hashCode(), copy);
        return copy.hashCode();
    }

    @Override
    public byte[] dataize(int vertex) {
        return (byte[])new Param(this.get(vertex), "\u0394").asBytes().take();
    }

    private Phi get(int vertex) {
        return Optional.ofNullable(this.indexed.get(vertex)).orElseThrow(() -> new ExFailure(String.format("Phi object with vertex %d was not indexed.", vertex), new Object[0]));
    }

    private static String replace(String name) {
        StringBuilder builder = new StringBuilder(name.length());
        block5: for (int iter = 0; iter < name.length(); ++iter) {
            char cur = name.charAt(iter);
            switch (cur) {
                case '^': {
                    builder.append('\u03c1');
                    continue block5;
                }
                case '@': {
                    builder.append('\u03c6');
                    continue block5;
                }
                case '&': {
                    builder.append('\u03c3');
                    continue block5;
                }
                default: {
                    builder.append(cur);
                }
            }
        }
        return builder.toString();
    }
}

