/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eolang.AtSimple;
import org.eolang.Attr;
import org.eolang.ExFailure;
import org.eolang.JavaPath;
import org.eolang.Phi;
import org.eolang.Versionized;

@Versionized
final class PhPackage
implements Phi {
    private final String pkg;
    private final ThreadLocal<Map<String, Phi>> objects = ThreadLocal.withInitial(() -> new ConcurrentHashMap(0));

    PhPackage(String name) {
        this.pkg = name;
    }

    @Override
    public Attr attr(String name) {
        String obj = this.eoPackage(name);
        String key = new JavaPath(obj).toString();
        if (!this.objects.get().containsKey(key)) {
            this.objects.get().put(key, this.loadPhi(key).orElseGet(() -> new PhPackage(obj)));
        }
        return new AtSimple(this.objects.get().get(key));
    }

    @Override
    public String locator() {
        return "?:?";
    }

    @Override
    public String forma() {
        throw new ExFailure(String.format("Can't #type() from package object '%s'", this.pkg), new Object[0]);
    }

    public String toString() {
        return String.format("\u03a6.%s", this.pkg);
    }

    @Override
    public String \u03c6Term() {
        return String.format("\u03a6.%s", this.pkg);
    }

    @Override
    public Attr attr(int pos) {
        throw new ExFailure(String.format("Can't #attr(%d) from package object '%s'", pos, this.pkg), new Object[0]);
    }

    @Override
    public Phi copy() {
        throw new ExFailure(String.format("Can't #copy() package object '%s'", this.pkg), new Object[0]);
    }

    private String eoPackage(String name) {
        StringBuilder abs = new StringBuilder(0).append(this.pkg);
        if (abs.length() > 0) {
            abs.append('.');
        }
        abs.append(name);
        return abs.toString();
    }

    private Optional<Phi> loadPhi(String target) {
        Optional<Phi> res;
        try {
            Phi kid = (Phi)Class.forName(target).getConstructor(Phi.class).newInstance(Phi.\u03a6);
            kid.attr("\u03c1").put(this);
            res = Optional.of(kid);
        }
        catch (ClassNotFoundException notfound) {
            res = Optional.empty();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ExFailure(String.format("Can't find Java object/package '%s' in EO package '%s'", target, this.pkg), ex);
        }
        return res;
    }
}

