/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import EOorg.EOeolang.EObool;
import EOorg.EOeolang.EObytes;
import EOorg.EOeolang.EOfloat;
import EOorg.EOeolang.EOint;
import EOorg.EOeolang.EOstring;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.commons.text.StringEscapeUtils;
import org.eolang.Attr;
import org.eolang.BytesOf;
import org.eolang.PhDefault;
import org.eolang.Phi;
import org.eolang.Term;
import org.eolang.Versionized;

@Versionized
public interface Data<T> {
    public T take();

    public static final class Value<T>
    extends PhDefault
    implements Data<T> {
        private final T val;

        public Value(T value) {
            super(Phi.\u03a6);
            this.val = value;
            this.vertex = PhDefault.VTX.best(value);
        }

        @Override
        public String \u03c6Term() {
            String txt;
            if (this.val instanceof Term) {
                txt = ((Term)Term.class.cast(this.val)).\u03c6Term();
            } else if (this.val instanceof Phi[]) {
                StringBuilder out = new StringBuilder(0);
                Phi[] items = (Phi[])Phi[].class.cast(this.val);
                for (int idx = 0; idx < items.length; ++idx) {
                    if (out.length() > 0) {
                        out.append(",\n");
                    }
                    out.append('\u03b9').append(idx).append(" \u21a6 ");
                    if (items[idx] == null) {
                        out.append('\u00d8');
                        continue;
                    }
                    out.append(items[idx].\u03c6Term());
                }
                txt = String.format("\u27e6\n\t%s\n\u27e7", out.toString());
            } else {
                txt = this.toString().replace("\u27e6", "\\uE29FA6").replace("\u27e7", "\\uE29FA7").replace(", ", "\\u2C ");
            }
            return txt;
        }

        @Override
        public String toString() {
            String txt;
            if (this.val instanceof String) {
                txt = String.format("\"%s\"", this.val.toString().replace("\n", "\\n").replace("\r", "\\r"));
            } else if (this.val instanceof byte[]) {
                StringBuilder out = new StringBuilder(0);
                for (byte data : (byte[])this.val) {
                    if (out.length() > 0) {
                        out.append('-');
                    }
                    out.append(String.format("%02X", data));
                }
                if (out.length() == 0) {
                    out.append('-');
                }
                txt = out.toString();
            } else {
                txt = this.val.getClass().isArray() ? String.format("array[%d]", ((Object[])this.val).length) : this.val.toString();
            }
            return txt;
        }

        @Override
        public T take() {
            return this.val;
        }
    }

    public static final class ToPhi
    implements Phi {
        private final Phi value;
        private final Phi object;

        public ToPhi(Object obj) {
            this.value = new Value<Object>(obj);
            this.object = ToPhi.toPhi(obj, this.value);
        }

        public boolean equals(Object obj) {
            return this.value.equals(obj);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public Phi copy() {
            return this;
        }

        @Override
        public Attr attr(int pos) {
            return this.object.attr(pos);
        }

        @Override
        public Attr attr(String name) {
            return this.object.attr(name);
        }

        @Override
        public String locator() {
            return this.object.locator();
        }

        @Override
        public String forma() {
            return this.object.forma();
        }

        @Override
        public String \u03c6Term() {
            return this.object.\u03c6Term();
        }

        public String toString() {
            return this.object.toString();
        }

        private static Phi toPhi(Object obj, Phi value) {
            boolean delta;
            EObool phi;
            byte[] bytes = new byte[]{};
            if (obj instanceof Boolean) {
                phi = new EObool(Phi.\u03a6);
                delta = false;
                bytes = obj.equals(true) ? new byte[]{1} : new byte[]{0};
            } else if (obj instanceof byte[]) {
                phi = new EObytes(Phi.\u03a6);
                delta = true;
            } else if (obj instanceof Long) {
                phi = new EOint(Phi.\u03a6);
                delta = false;
                bytes = new BytesOf((Long)obj).take();
            } else if (obj instanceof String) {
                phi = new EOstring(Phi.\u03a6);
                delta = false;
                bytes = StringEscapeUtils.unescapeJava((String)((String)obj)).getBytes(StandardCharsets.UTF_8);
            } else if (obj instanceof Double) {
                phi = new EOfloat(Phi.\u03a6);
                delta = false;
                bytes = new BytesOf((Double)obj).take();
            } else {
                throw new IllegalArgumentException(String.format("Unknown type of data: %s", obj.getClass().getCanonicalName()));
            }
            if (delta) {
                phi.attr("\u0394").put(value);
            } else {
                EObytes bts = new EObytes(Phi.\u03a6);
                bts.attr("\u0394").put(new Value<byte[]>(bytes));
                phi.attr(0).put((Phi)bts);
            }
            return phi;
        }
    }

    public static final class Once<T>
    implements Data<T> {
        private final Data<T> src;
        private final AtomicReference<T> ref;
        private final Supplier<String> blank;

        public Once(Data<T> data, Supplier<String> txt) {
            this.src = data;
            this.ref = new AtomicReference();
            this.blank = txt;
        }

        public int hashCode() {
            return this.take().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.take().equals(((Once)obj).take());
        }

        public String toString() {
            T data = this.ref.get();
            String txt = this.blank.get();
            if (txt.isEmpty()) {
                txt = this.take().toString();
            } else if (data != null) {
                txt = data.toString();
            }
            return txt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T take() {
            AtomicReference<T> atomicReference = this.ref;
            synchronized (atomicReference) {
                return this.ref.updateAndGet(t -> {
                    Object result = t == null ? this.src.take() : t;
                    return result;
                });
            }
        }
    }
}

