/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.eolang.Data;
import org.eolang.Dataized;
import org.eolang.ExFailure;
import org.eolang.Expr;
import org.eolang.Param;
import org.eolang.Phi;

public final class ExprReduce<T>
implements Expr {
    private final String param;
    private final BinaryOperator<T> reduction;
    private final Args<T> arguments;

    public ExprReduce(String param, BinaryOperator<T> reduction, Args<T> arguments) {
        this.param = param;
        this.reduction = reduction;
        this.arguments = arguments;
    }

    @Override
    public Phi get(Phi rho) {
        Optional acc = this.arguments.get(rho, this.param).stream().reduce(this.reduction);
        if (!acc.isPresent()) {
            throw new IllegalStateException(String.format("Unable to reduce expression for %s", rho));
        }
        return new Data.ToPhi(acc.get());
    }

    public static final class Args<T> {
        private final Class<T> type;
        private final Function<T, String> validation;
        private final String oper;

        public Args(Class<T> type, Function<T, String> validation, String oper) {
            this.type = type;
            this.validation = validation;
            this.oper = oper;
        }

        public List<T> get(Phi rho, String param) {
            T acc = new Param(rho).strong(this.type);
            Phi[] args = new Param(rho, param).strong(Phi[].class);
            ArrayList<T> list = new ArrayList<T>(args.length + 1);
            list.add(acc);
            for (int idx = 0; idx < args.length; ++idx) {
                Object val = new Dataized(args[idx]).take();
                if (!val.getClass().getCanonicalName().equals(this.type.getCanonicalName())) {
                    throw new ExFailure("The %dth argument of '%s' is not a(n) %s: %s", idx + 1, this.oper, this.type.getSimpleName(), val);
                }
                T typed = this.type.cast(val);
                String msg = this.validation.apply(typed);
                if (!msg.isEmpty()) {
                    throw new ExFailure("The %dth argument of '%s' is invalid: %s", idx + 1, this.oper, msg);
                }
                list.add(typed);
            }
            return list;
        }
    }
}

