/*
 * Decompiled with CFR 0.152.
 */
package EOorg.EOeolang;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.SystemUtils;
import org.cactoos.Bytes;
import org.cactoos.Text;
import org.cactoos.bytes.Base64Bytes;
import org.cactoos.bytes.BytesOf;
import org.cactoos.bytes.IoCheckedBytes;
import org.cactoos.text.TextOf;
import org.eolang.AtComposite;
import org.eolang.AtFree;
import org.eolang.Data;
import org.eolang.ExFailure;
import org.eolang.PhDefault;
import org.eolang.Phi;
import org.eolang.XmirObject;

@XmirObject(oname="rust")
public class EOrust
extends PhDefault {
    private static final ConcurrentHashMap<String, String> NAMES;

    public EOrust(Phi sigma) {
        super(sigma);
        this.add("code", new AtFree());
        this.add("params", new AtFree());
        this.add("\u03c6", new AtComposite(this, rho -> {
            String name = NAMES.get(rho.attr("code").get().locator().split(":")[0]);
            Method method = Class.forName(String.format("EOrust.natives.%s", name)).getDeclaredMethod(name, EOrust.class);
            if (method.getReturnType() != byte[].class) {
                throw new ExFailure("Return type of %s is %s, required %s", method, method.getReturnType(), byte[].class);
            }
            return EOrust.translate((byte[])method.invoke(null, this));
        }));
    }

    public int find(String name) {
        return 0;
    }

    public void put(int vertex, byte[] bytes) {
    }

    public void bind(int parent, int child, String att) {
    }

    public int copy(int vertex) {
        return vertex;
    }

    private static ConcurrentHashMap<String, String> load(String src) throws IOException {
        ConcurrentHashMap concurrentHashMap;
        ObjectInputStream map = new ObjectInputStream(new ByteArrayInputStream(new IoCheckedBytes((Bytes)new Base64Bytes((Bytes)new BytesOf((Text)new TextOf(Paths.get(src, new String[0]))))).asBytes()));
        try {
            Object result = map.readObject();
            if (result.getClass() != ConcurrentHashMap.class) {
                throw new ClassCastException(String.format("Object inside %s has wrong class %s", src, result.getClass()));
            }
            concurrentHashMap = (ConcurrentHashMap)result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    map.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException exc) {
                throw new IllegalArgumentException(String.format("File %s contains invalid data", src), exc);
            }
        }
        map.close();
        return concurrentHashMap;
    }

    private static Phi translate(byte[] message) {
        Data.ToPhi ret;
        byte determinant = message[0];
        byte[] content = Arrays.copyOfRange(message, 1, message.length);
        switch (determinant) {
            case 0: {
                throw new ExFailure("Returning vertex is not implemented yet", new Object[0]);
            }
            case 1: {
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.put(content);
                buffer.flip();
                ret = new Data.ToPhi(buffer.getDouble());
                break;
            }
            case 2: {
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.put(content);
                buffer.flip();
                ret = new Data.ToPhi(buffer.getLong());
                break;
            }
            default: {
                throw new ExFailure("Returning Strings and raw bytes is not implemented yet", new Object[0]);
            }
        }
        return ret;
    }

    static {
        String lib;
        try {
            NAMES = EOrust.load("target/names");
        }
        catch (IOException exc) {
            throw new ExFailure("Cannot read the file target/eo-test/names", exc);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            lib = "common.dll";
        } else if (SystemUtils.IS_OS_LINUX) {
            lib = "libcommon.so";
        } else if (SystemUtils.IS_OS_MAC) {
            lib = "libcommon.dylib";
        } else {
            throw new NotImplementedException(String.format("Rust inserts are not supported by %s os. Only windows, linux and macos are allowed.", System.getProperty("os.name")));
        }
        File libs = Paths.get("target", new String[0]).resolve("eo-test").resolve("Lib").toFile();
        if (libs.isDirectory()) {
            for (File subdir : libs.listFiles()) {
                Path path = subdir.toPath().resolve("target").resolve("debug").resolve(lib).toAbsolutePath();
                if (!path.toFile().exists()) continue;
                System.load(path.toString());
            }
        }
    }
}

