/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import EOorg.EOeolang.EOstring;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eolang.Data;
import org.eolang.Dataized;
import org.eolang.ExAbstract;
import org.eolang.ExUnset;
import org.eolang.JavaPath;
import org.eolang.Phi;

public final class Main {
    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());
    private static final Logger EOLOG = Logger.getLogger("org.eolang");

    private Main() {
    }

    public static void main(String ... args) throws Exception {
        Main.setup();
        ArrayList<String> opts = new ArrayList<String>(args.length);
        opts.addAll(Arrays.asList(args));
        while (!opts.isEmpty()) {
            String opt = (String)opts.get(0);
            if (Main.parse(opt)) {
                return;
            }
            if (!opt.startsWith("--")) break;
            opts.remove(0);
        }
        LOGGER.log(Level.FINE, String.format("EOLANG Runtime %s", Main.version()));
        if (opts.isEmpty()) {
            throw new IllegalStateException("A name of EO object is expected as a command line argument");
        }
        try {
            Main.run(opts);
        }
        catch (ExAbstract ex) {
            Main.print(ex);
            System.exit(1);
        }
    }

    private static void print(Throwable thr) {
        LOGGER.log(Level.SEVERE, thr.getMessage());
        Throwable cause = thr.getCause();
        if (cause != null) {
            Main.print(cause);
        }
    }

    private static void setup() {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord rec) {
                return String.format("%s%n", rec.getMessage());
            }
        });
        EOLOG.addHandler(handler);
        EOLOG.setUseParentHandlers(false);
    }

    private static boolean parse(String opt) throws IOException {
        if ("--verbose".equals(opt)) {
            EOLOG.setLevel(Level.FINE);
            for (Handler hnd : EOLOG.getHandlers()) {
                hnd.setLevel(Level.FINE);
            }
        }
        boolean exit = false;
        if ("--version".equals(opt)) {
            LOGGER.info(Main.version());
            exit = true;
        }
        if ("--help".equals(opt)) {
            LOGGER.info(String.join((CharSequence)"\n", "Usage: java -cp target/classes org.eolang.Main [option...] class [argument...]", "  class: Name of EO class, e.g. \"org.eolang.io.stdio\"", "  argument: Value that will be wrapped as strings and passed to your EO object", "  options:", "    --help     Print this documentation and exit", "    --version  Print the version of this JAR and exit", "    --verbose  Print all intermediate dataization results"));
            exit = true;
        }
        return exit;
    }

    private static void run(List<String> opts) throws Exception {
        Phi app;
        String path = new JavaPath(opts.get(0)).toString();
        try {
            LOGGER.fine(String.format("Loading class %s...", path));
            app = (Phi)Phi.class.cast(Class.forName(path).getConstructor(Phi.class).newInstance(Phi.\u03a6));
        }
        catch (ClassNotFoundException ex) {
            throw new ExUnset(String.format("Can not find '%s' object", opts.get(0)));
        }
        for (int idx = 1; idx < opts.size(); ++idx) {
            EOstring phi = new EOstring(Phi.\u03a6);
            String arg = opts.get(idx);
            phi.attr("\u0394").put(new Data.Value<String>(arg));
            app.attr(0).put((Phi)phi);
        }
        LOGGER.info(String.format("%n---%n%s", new Dataized(app).take().toString()));
    }

    private static String version() throws IOException {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(Objects.requireNonNull(Main.class.getResourceAsStream("version.txt")), StandardCharsets.UTF_8));){
            String string = input.lines().findFirst().orElse("N/A");
            return string;
        }
    }
}

