/*
 * Decompiled with CFR 0.152.
 */
package EOorg.EOeolang.EOtxt;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.eolang.AtComposite;
import org.eolang.AtFree;
import org.eolang.Data;
import org.eolang.ExFailure;
import org.eolang.Param;
import org.eolang.PhDefault;
import org.eolang.Phi;
import org.eolang.XmirObject;

@XmirObject(oname="sscanf")
public class EOsscanf
extends PhDefault {
    public EOsscanf(Phi sigma) {
        super(sigma);
        this.add("format", new AtFree());
        this.add("read", new AtFree());
        this.add("\u03c6", new AtComposite(this, rho -> {
            String format = new Param(rho, "format").strong(String.class);
            String read = new Param(rho, "read").strong(String.class);
            ArrayList<Data.ToPhi> buffer = new ArrayList<Data.ToPhi>(0);
            try (Scanner fsc = new Scanner(format);
                 Scanner rsc = new Scanner(read);){
                while (fsc.hasNext() && rsc.hasNext()) {
                    String pattern = fsc.next();
                    String val = rsc.next();
                    boolean valid = pattern.contains(String.valueOf('%')) && pattern.length() > 1;
                    if (!valid) continue;
                    int start = pattern.indexOf(37);
                    char chr = pattern.charAt(start + 1);
                    if (!Conversion.isValid(chr)) {
                        throw new ExFailure("Can't recognize format pattern: %s", pattern);
                    }
                    if (pattern.length() > 2) {
                        int end = start + 1 == pattern.length() - 1 ? 0 : pattern.length() - (start + 2);
                        val = val.substring(start, val.length() - end);
                    }
                    if (Conversion.isString(chr) || Conversion.isCharacter(chr)) {
                        buffer.add(new Data.ToPhi(val));
                        continue;
                    }
                    if (Conversion.isInteger(chr)) {
                        buffer.add(new Data.ToPhi(Long.parseLong(val)));
                        continue;
                    }
                    if (Conversion.isFloat(chr)) {
                        buffer.add(new Data.ToPhi(Double.parseDouble(val)));
                        continue;
                    }
                    if (Conversion.isBoolean(chr)) {
                        buffer.add(new Data.ToPhi(Boolean.parseBoolean(val)));
                        continue;
                    }
                    throw new ExFailure("Format pattern not supported yet: %s", pattern);
                }
            }
            catch (IllegalArgumentException | NullPointerException | NoSuchElementException ex) {
                throw new ExFailure(ex.getMessage(), new Object[0]);
            }
            return new Data.ToPhi(buffer.toArray(new Phi[0]));
        }));
    }

    private static class Conversion {
        static final char DECIMAL_INTEGER = 'd';
        static final char OCTAL_INTEGER = 'o';
        static final char HEXADECIMAL_INTEGER = 'x';
        static final char HEXADECIMAL_INTEGER_UPPER = 'X';
        static final char SCIENTIFIC = 'e';
        static final char SCIENTIFIC_UPPER = 'E';
        static final char GENERAL = 'g';
        static final char GENERAL_UPPER = 'G';
        static final char DECIMAL_FLOAT = 'f';
        static final char HEXADECIMAL_FLOAT = 'a';
        static final char HEXADECIMAL_FLOAT_UPPER = 'A';
        static final char CHARACTER = 'c';
        static final char CHARACTER_UPPER = 'C';
        static final char DATE_TIME = 't';
        static final char DATE_TIME_UPPER = 'T';
        static final char BOOLEAN = 'b';
        static final char BOOLEAN_UPPER = 'B';
        static final char STRING = 's';
        static final char STRING_UPPER = 'S';
        static final char HASHCODE = 'h';
        static final char HASHCODE_UPPER = 'H';
        static final char LINE_SEPARATOR = 'n';
        static final char PERCENT_SIGN = '%';

        private Conversion() {
        }

        static boolean isValid(char character) {
            boolean result;
            switch (character) {
                case '%': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'E': 
                case 'G': 
                case 'H': 
                case 'S': 
                case 'X': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'n': 
                case 'o': 
                case 's': 
                case 'x': {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
            return result;
        }

        static boolean isGeneral(char character) {
            boolean result;
            switch (character) {
                case 'B': 
                case 'H': 
                case 'S': 
                case 'b': 
                case 'h': 
                case 's': {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
            return result;
        }

        static boolean isString(char character) {
            boolean result;
            switch (character) {
                case 'S': 
                case 's': {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
            return result;
        }

        static boolean isBoolean(char character) {
            boolean result;
            switch (character) {
                case 'B': 
                case 'b': {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
            return result;
        }

        static boolean isCharacter(char character) {
            boolean result;
            switch (character) {
                case 'C': 
                case 'c': {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
            return result;
        }

        static boolean isInteger(char character) {
            boolean result;
            switch (character) {
                case 'X': 
                case 'd': 
                case 'o': 
                case 'x': {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
            return result;
        }

        static boolean isFloat(char character) {
            boolean result;
            switch (character) {
                case 'A': 
                case 'E': 
                case 'G': 
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
            return result;
        }

        static boolean isText(char character) {
            boolean result;
            switch (character) {
                case '%': 
                case 'n': {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
            return result;
        }
    }
}

