/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.eolang.Dataized;
import org.eolang.ExFailure;
import org.eolang.Phi;

public final class Param {
    private final Phi rho;
    private final String attr;

    public Param(Phi obj) {
        this(obj, "\u03c1");
    }

    public Param(Phi obj, String name) {
        this.rho = obj;
        this.attr = name;
    }

    public <T> T strong(Class<T> type) {
        Object ret = this.weak();
        if (!type.isInstance(ret)) {
            throw new ExFailure(String.format("The argument '.%s' is of Java type '%s', not '%s' as expected", this.attr, ret.getClass().getCanonicalName(), type.getCanonicalName()), new Object[0]);
        }
        return type.cast(ret);
    }

    public Object weak() {
        return new Dataized(this.rho.attr(this.attr).get()).take();
    }

    public <T> T fromBytes(Class<T> type) {
        Comparable<BigInteger> res;
        byte[] ret = this.strong(byte[].class);
        if (BigInteger.class.equals(type)) {
            res = new BigInteger(ret);
        } else if (Long.class.equals(type)) {
            if (ret.length == 1) {
                res = Long.valueOf(ret[0]);
            } else {
                byte[] cpy = new byte[8];
                int posx = cpy.length;
                int posy = ret.length;
                while (posy-- > 0 && posx-- > 0) {
                    cpy[posx] = ret[posy];
                }
                if (ret[0] < 0) {
                    while (posx-- > 0) {
                        cpy[posx] = -1;
                    }
                }
                res = ByteBuffer.wrap(cpy).getLong();
            }
        } else if (Character.class.equals(type)) {
            res = Character.valueOf(ByteBuffer.wrap(ret).getChar());
        } else if (Double.class.equals(type)) {
            res = ByteBuffer.wrap(ret).getDouble();
        } else {
            throw new ExFailure(String.format("Unsupported type: '%s'", type), new Object[0]);
        }
        return type.cast(res);
    }

    public byte[] asBytes() {
        byte[] res;
        Object ret = this.weak();
        if (Long.class.isInstance(ret)) {
            res = ByteBuffer.allocate(8).putLong((Long)ret).array();
        } else if (Character.class.isInstance(ret)) {
            res = ByteBuffer.allocate(2).putChar(((Character)ret).charValue()).array();
        } else if (Double.class.isInstance(ret)) {
            res = ByteBuffer.allocate(8).putDouble((Double)ret).array();
        } else {
            throw new ExFailure(String.format("Unsupported type: %s", ret.getClass()), new Object[0]);
        }
        return res;
    }
}

