/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.eolang.Data;
import org.eolang.Dataized;
import org.eolang.ExFailure;
import org.eolang.Expr;
import org.eolang.Param;
import org.eolang.Phi;

public final class ExprReduce<T>
implements Expr {
    private final String param;
    private final Class<T> type;
    private final BiFunction<T, T, T> reduction;
    private final Function<T, String> validation;
    private final String oper;

    public ExprReduce(String oper, String param, Class<T> type, BiFunction<T, T, T> reduction, Function<T, String> validation) {
        this.param = param;
        this.type = type;
        this.reduction = reduction;
        this.oper = oper;
        this.validation = validation;
    }

    public ExprReduce(String oper, String param, Class<T> type, BiFunction<T, T, T> reduction) {
        this(oper, param, type, reduction, x -> "");
    }

    @Override
    public Phi get(Phi rho) {
        T acc = new Param(rho).strong(this.type);
        Phi[] args = new Param(rho, this.param).strong(Phi[].class);
        for (int idx = 0; idx < args.length; ++idx) {
            Object val = new Dataized(args[idx]).take();
            if (!val.getClass().getCanonicalName().equals(this.type.getCanonicalName())) {
                throw new ExFailure("The %dth argument of '%s' is not a(n) %s: %s", idx + 1, this.oper, this.type.getSimpleName(), val);
            }
            T typed = this.type.cast(val);
            String msg = this.validation.apply(typed);
            if (!msg.isEmpty()) {
                throw new ExFailure("The %dth argument of '%s' is invalid: %s", idx + 1, this.oper, msg);
            }
            acc = this.reduction.apply(acc, typed);
        }
        return new Data.ToPhi(acc);
    }
}

