/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.eolang.Phi;

final class Vertices {
    private final AtomicInteger count = new AtomicInteger();
    private final ConcurrentHashMap<String, Integer> seen = new ConcurrentHashMap(0);

    Vertices() {
    }

    public int next() {
        return this.seen.computeIfAbsent(String.format("next:%d", this.count.addAndGet(1)), key -> this.seen.size() + 1);
    }

    public int best(Object obj) {
        MessageDigest digest;
        String label;
        if (obj instanceof Phi[]) {
            return this.next();
        }
        if (obj instanceof Long || obj instanceof String || obj instanceof Character || obj instanceof Double || obj instanceof Boolean) {
            label = obj.toString();
        } else if (obj instanceof Pattern) {
            label = ((Pattern)Pattern.class.cast(obj)).pattern();
        } else if (obj instanceof byte[]) {
            label = Arrays.toString((byte[])byte[].class.cast(obj));
        } else {
            throw new IllegalArgumentException(String.format("Unknown type for vertex allocation: %s", obj.getClass().getCanonicalName()));
        }
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
        digest.update(String.format("%s %s", obj.getClass().getName(), label).getBytes());
        String hash = new String(digest.digest());
        return this.seen.computeIfAbsent(hash, key -> this.seen.size() + 1);
    }
}

