/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eolang.AtAbsent;
import org.eolang.AtNamed;
import org.eolang.AtPhiSensitive;
import org.eolang.AtSimple;
import org.eolang.AtVararg;
import org.eolang.Attr;
import org.eolang.CachedPhi;
import org.eolang.Data;
import org.eolang.ExFailure;
import org.eolang.Indented;
import org.eolang.Phi;
import org.eolang.Vertices;
import org.eolang.Volatile;
import org.eolang.XmirObject;

public abstract class PhDefault
implements Phi,
Cloneable {
    private static final Pattern SORTABLE = Pattern.compile("^[a-z].*$");
    protected static final Vertices VTX = new Vertices();
    private final List<String> order;
    protected int vertex;
    private Map<String, Attr> attrs;
    private CachedPhi cached = new CachedPhi();
    private final ThreadLocal<Set<Integer>> terms = new ThreadLocal();
    private final ThreadLocal<Set<Integer>> strings = new ThreadLocal();

    public PhDefault() {
        this(Phi.\u03a6);
    }

    public PhDefault(Phi sigma) {
        this.vertex = VTX.next();
        this.attrs = new HashMap<String, Attr>(0);
        this.order = new ArrayList<String>(0);
        this.add("\u03c1", new AtSimple(sigma));
        this.add("\u03c3", new AtSimple(sigma));
    }

    public boolean equals(Object obj) {
        return obj instanceof Phi && this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return this.vertex;
    }

    @Override
    public String \u03c6Term() {
        if (this.terms.get() == null) {
            this.terms.set(new HashSet());
        }
        if (this.terms.get().contains(this.vertex)) {
            return String.format("\u03bd%d", this.vertex);
        }
        this.terms.get().add(this.vertex);
        ArrayList<String> list = new ArrayList<String>(this.attrs.size());
        for (Map.Entry<String, Attr> ent : this.attrs.entrySet()) {
            String attr = String.format("%s \u21a6 %s", ent.getKey(), ent.getValue().\u03c6Term());
            list.add(attr);
        }
        this.terms.get().remove(this.vertex);
        Collections.sort(list);
        String txt = this.getClass().getSimpleName();
        XmirObject xmir = this.getClass().getAnnotation(XmirObject.class);
        if (xmir != null && "@".equals(txt = xmir.oname())) {
            txt = "\u03c6";
        }
        if (!list.isEmpty()) {
            txt = String.format("\u03bd%d\u00b7%s\u27e6\n\t%s\n\u27e7", this.vertex, txt, new Indented(String.join((CharSequence)",\n", list)));
        }
        return txt;
    }

    public String toString() {
        return this.toStringWith(new String[0]);
    }

    @Override
    public final Phi copy() {
        try {
            PhDefault copy = (PhDefault)PhDefault.class.cast(this.clone());
            copy.vertex = VTX.next();
            copy.cached = new CachedPhi();
            HashMap<String, Attr> map = new HashMap<String, Attr>(this.attrs.size());
            for (Map.Entry<String, Attr> ent : this.attrs.entrySet()) {
                map.put(ent.getKey(), ent.getValue().copy(copy));
            }
            copy.attrs = map;
            return copy;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public final void move(Phi rho) {
        this.attrs.put("\u03c1", new AtSimple(rho));
    }

    @Override
    public final Attr attr(int pos) {
        int idx;
        if (pos < 0) {
            throw new ExFailure(String.format("Attribute position can't be negative (%d)", pos));
        }
        if (this.order.isEmpty()) {
            throw new ExFailure(String.format("There are no attributes here, can't read the %d-th one", pos));
        }
        for (idx = 0; idx < pos; ++idx) {
            if (idx >= this.order.size()) {
                throw new ExFailure(String.format("There are just %d attributes here, can't read the %d-th one", this.order.size(), pos));
            }
            String name = this.order.get(idx);
            if (this.attrs.get(name) instanceof AtVararg) break;
        }
        return this.attr(this.order.get(idx));
    }

    @Override
    public final Attr attr(String name) {
        Attr attr = "\u03bd".equals(name) ? new AtSimple(new Data.ToPhi(this.hashCode())) : this.attrs.get(name);
        if (attr == null) {
            Attr aphi = this.attrs.get("\u03c6");
            if (aphi == null) {
                attr = new AtAbsent(name, String.format(" among other %d attrs (%s) and \u03c6 is absent", this.attrs.size(), String.join((CharSequence)", ", this.attrs.keySet())));
            } else {
                Phi phi = this.cached.get(name, aphi::get);
                Phi found = phi.attr(name).get();
                found.move(this);
                return new AtSimple(found);
            }
        }
        attr = this.named(attr, name);
        if ("\u03c6".equals(name)) {
            attr = new AtPhiSensitive(attr, this.cached);
        }
        if (this.getClass().isAnnotationPresent(Volatile.class)) {
            this.cached.reset();
        }
        return attr;
    }

    protected final void add(String name, Attr attr) {
        if (SORTABLE.matcher(name).matches()) {
            this.order.add(name);
        }
        this.attrs.put(name, attr);
    }

    private Attr named(Attr attr, String name) {
        return new AtNamed(String.format("%s#%s", this.getClass().getCanonicalName(), name), String.format("%s.%s", this.oname(), name), this, attr);
    }

    private String oname() {
        String txt = this.getClass().getSimpleName();
        XmirObject xmir = this.getClass().getAnnotation(XmirObject.class);
        if (xmir != null && "@".equals(txt = xmir.oname())) {
            txt = "\u03c6";
        }
        return txt;
    }

    protected String toStringWith(String ... lines) {
        if (this.strings.get() == null) {
            this.strings.set(new HashSet());
        }
        if (this.strings.get().contains(this.vertex)) {
            return String.format("\u03bd%d", this.vertex);
        }
        this.strings.get().add(this.vertex);
        ArrayList<String> list = new ArrayList<String>(this.attrs.size());
        for (String line : lines) {
            list.add(new Indented(line).toString());
        }
        list.add(String.format("\u25b8order=%s", new Indented(this.order)));
        list.add(String.format("\u25b8cached=%s", new Indented(this.cached)));
        ArrayList<String> sorted = new ArrayList<String>(this.attrs.size());
        for (Map.Entry<String, Attr> ent : this.attrs.entrySet()) {
            int idx = this.order.indexOf(ent.getKey());
            sorted.add(String.format("%s%s=%s", ent.getKey(), idx >= 0 ? String.format("(#%d)", idx) : "", new Indented(ent.getValue())));
        }
        this.strings.get().remove(this.vertex);
        Collections.sort(sorted);
        list.addAll(sorted);
        return String.format("%s\u03bd%d:{\n  %s\n}", this.getClass().getCanonicalName(), this.vertex, String.join((CharSequence)"\n\t", list));
    }
}

