/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import EOorg.EOeolang.EOarray;
import EOorg.EOeolang.EObool;
import EOorg.EOeolang.EObytes;
import EOorg.EOeolang.EOfloat;
import EOorg.EOeolang.EOint;
import EOorg.EOeolang.EOregex;
import EOorg.EOeolang.EOstring;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.eolang.Attr;
import org.eolang.PhDefault;
import org.eolang.Phi;
import org.eolang.Term;

public interface Data<T> {
    public T take();

    public static final class Value<T>
    extends PhDefault
    implements Data<T> {
        private final T val;

        public Value(T value) {
            super(Phi.\u03a6);
            this.val = value;
            this.vertex = PhDefault.VTX.best(value);
        }

        @Override
        public String \u03c6Term() {
            String txt;
            if (this.val instanceof Term) {
                txt = ((Term)Term.class.cast(this.val)).\u03c6Term();
            } else if (this.val instanceof Phi[]) {
                StringBuilder out = new StringBuilder(0);
                Phi[] items = (Phi[])Phi[].class.cast(this.val);
                for (int idx = 0; idx < items.length; ++idx) {
                    if (out.length() > 0) {
                        out.append(",\n");
                    }
                    out.append('\u03b9').append(idx).append(" \u21a6 ");
                    if (items[idx] == null) {
                        out.append('\u00d8');
                        continue;
                    }
                    out.append(items[idx].\u03c6Term());
                }
                txt = String.format("\u27e6\n\t%s\n\u27e7", out.toString());
            } else {
                txt = this.toString().replace("\u27e6", "\\uE29FA6").replace("\u27e7", "\\uE29FA7").replace(", ", "\\u2C ");
            }
            return txt;
        }

        @Override
        public String toString() {
            String txt;
            if (this.val instanceof String) {
                txt = String.format("\"%s\"", this.val.toString().replace("\n", "\\n").replace("\r", "\\r"));
            } else if (this.val instanceof byte[]) {
                StringBuilder out = new StringBuilder(0);
                for (byte data : (byte[])this.val) {
                    if (out.length() > 0) {
                        out.append('-');
                    }
                    out.append(String.format("%02X", data));
                }
                if (out.length() == 0) {
                    out.append('-');
                }
                txt = out.toString();
            } else {
                txt = this.val.getClass().isArray() ? Arrays.toString((Object[])this.val) : this.val.toString();
            }
            return txt;
        }

        @Override
        public T take() {
            return this.val;
        }
    }

    public static final class ToPhi
    implements Phi {
        private final Phi value;
        private final Phi object;

        public ToPhi(Object obj) {
            this.value = new Value<Object>(obj);
            this.object = ToPhi.toPhi(obj);
            this.object.attr("\u0394").put(this.value);
        }

        public boolean equals(Object obj) {
            return this.value.equals(obj);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public Phi copy() {
            return this;
        }

        @Override
        public void move(Phi rho) {
        }

        @Override
        public Attr attr(int pos) {
            return this.object.attr(pos);
        }

        @Override
        public Attr attr(String name) {
            return this.object.attr(name);
        }

        @Override
        public String \u03c6Term() {
            return this.object.\u03c6Term();
        }

        public String toString() {
            return this.object.toString();
        }

        private static Phi toPhi(Object obj) {
            PhDefault phi;
            if (obj instanceof Boolean) {
                phi = new EObool(Phi.\u03a6);
            } else if (obj instanceof byte[]) {
                phi = new EObytes(Phi.\u03a6);
            } else if (obj instanceof Long) {
                phi = new EOint(Phi.\u03a6);
            } else if (obj instanceof String) {
                phi = new EOstring(Phi.\u03a6);
            } else if (obj instanceof Double) {
                phi = new EOfloat(Phi.\u03a6);
            } else if (obj instanceof Pattern) {
                phi = new EOregex(Phi.\u03a6);
            } else if (obj instanceof Phi[]) {
                phi = new EOarray(Phi.\u03a6);
            } else {
                throw new IllegalArgumentException(String.format("Unknown type of data: %s", obj.getClass().getCanonicalName()));
            }
            return phi;
        }
    }

    public static final class Once<T>
    implements Data<T> {
        private final Data<T> src;
        private final AtomicReference<T> ref;
        private final Supplier<String> blank;

        public Once(Data<T> data, Supplier<String> txt) {
            this.src = data;
            this.ref = new AtomicReference();
            this.blank = txt;
        }

        public int hashCode() {
            return this.take().hashCode();
        }

        public String toString() {
            T data = this.ref.get();
            String txt = this.blank.get();
            if (txt.isEmpty()) {
                txt = this.src.take().toString();
            } else if (data != null) {
                txt = data.toString();
            }
            return txt;
        }

        @Override
        public T take() {
            if (this.ref.get() == null) {
                this.ref.set(this.src.take());
            }
            return this.ref.get();
        }
    }
}

