/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eolang.Data;
import org.eolang.ExFailure;
import org.eolang.Indented;
import org.eolang.Phi;

public final class Dataized {
    private static final Logger LOGGER = Logger.getLogger(Dataized.class.getName());
    private static final ThreadLocal<Integer> LEVEL = ThreadLocal.withInitial(() -> 0);
    private final Phi phi;

    public Dataized(Phi src) {
        this.phi = src;
    }

    public Object take() {
        int before = LEVEL.get();
        LEVEL.set(before + 1);
        Phi src = this.phi;
        try {
            if (!(src instanceof Data)) {
                src = src.attr("\u0394").get();
            }
        }
        catch (ExFailure ex) {
            throw new ExFailure(String.format("Attribute failure at:%n\t%s", new Indented(this.phi.toString())), ex);
        }
        if (!(src instanceof Data)) {
            throw new ExFailure(String.format("The attribute \u0394 has %s instead of %s at:%n\t%s", src.getClass().getCanonicalName(), Data.class.getCanonicalName(), new Indented(this.phi)));
        }
        Object data = ((Data)Data.class.cast(src)).take();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format("%s\ud835\udd3b( %s ) \u279c %s", String.join((CharSequence)"", Collections.nCopies(before, "\u00b7")), this.phi.\u03c6Term().replaceAll("[\n\t]", ""), new Data.Value(data).\u03c6Term()));
        }
        LEVEL.set(before);
        return data;
    }

    public <T> T take(Class<T> type) {
        return type.cast(this.take());
    }
}

