/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.parser;

import com.jcabi.manifests.Manifests;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.cactoos.list.Mapped;
import org.cactoos.text.Joined;
import org.eolang.parser.ParsingException;
import org.eolang.parser.ProgramListener;
import org.eolang.parser.ProgramParser;
import org.w3c.dom.Node;
import org.xembly.Directives;
import org.xembly.Xembler;

public final class XeListener
implements ProgramListener {
    private final String name;
    private final Directives dirs;
    private final long start;

    public XeListener(String nme) {
        this.name = nme;
        this.dirs = new Directives();
        this.start = System.nanoTime();
    }

    public XML xml() {
        return new XMLDocument((Node)new Xembler((Iterable)this.dirs).domQuietly());
    }

    @Override
    public void enterProgram(ProgramParser.ProgramContext ctx) {
        this.dirs.add((Object)"program").attr((Object)"name", (Object)this.name).attr((Object)"version", (Object)Manifests.read((String)"EO-Version")).attr((Object)"time", (Object)ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT)).add((Object)"listing").set((Object)ctx.getText()).up().add((Object)"errors").up().add((Object)"sheets").up();
    }

    @Override
    public void exitProgram(ProgramParser.ProgramContext ctx) {
        this.dirs.attr((Object)"ms", (Object)((System.nanoTime() - this.start) / 1000000L)).up();
    }

    @Override
    public void enterLicense(ProgramParser.LicenseContext ctx) {
        this.dirs.add((Object)"license").set((Object)new Joined("\n", (Iterable)new Mapped(cmt -> cmt.getText().substring(1).trim(), ctx.COMMENT()))).up();
    }

    @Override
    public void exitLicense(ProgramParser.LicenseContext ctx) {
    }

    @Override
    public void enterMetas(ProgramParser.MetasContext ctx) {
        this.dirs.add((Object)"metas");
        for (TerminalNode node : ctx.META()) {
            String[] pair = node.getText().split(" ", 2);
            this.dirs.add((Object)"meta").attr((Object)"line", (Object)node.getSymbol().getLine()).add((Object)"head").set((Object)pair[0].substring(1)).up().add((Object)"tail");
            if (pair.length > 1) {
                this.dirs.set((Object)pair[1].trim()).up();
                for (String part : pair[1].trim().split(" ")) {
                    this.dirs.add((Object)"part").set((Object)part).up();
                }
            } else {
                this.dirs.up();
            }
            this.dirs.up();
        }
        this.dirs.up();
    }

    @Override
    public void exitMetas(ProgramParser.MetasContext ctx) {
    }

    @Override
    public void enterObjects(ProgramParser.ObjectsContext ctx) {
        this.dirs.add((Object)"objects");
    }

    @Override
    public void exitObjects(ProgramParser.ObjectsContext ctx) {
        this.dirs.up();
    }

    @Override
    public void enterObject(ProgramParser.ObjectContext ctx) {
    }

    @Override
    public void exitObject(ProgramParser.ObjectContext ctx) {
    }

    @Override
    public void enterAnonymous(ProgramParser.AnonymousContext ctx) {
        this.dirs.add((Object)"o").attr((Object)"line", (Object)ctx.getStart().getLine()).up();
    }

    @Override
    public void exitAnonymous(ProgramParser.AnonymousContext ctx) {
        this.enter();
        this.dirs.xpath((Object)"o[@base][1]").up().up();
    }

    @Override
    public void enterAbstraction(ProgramParser.AbstractionContext ctx) {
        this.dirs.add((Object)"o").attr((Object)"line", (Object)ctx.getStart().getLine());
        if (ctx.SLASH() != null) {
            this.dirs.attr((Object)"atom", (Object)ctx.NAME());
        }
        this.dirs.up();
    }

    @Override
    public void exitAbstraction(ProgramParser.AbstractionContext ctx) {
    }

    @Override
    public void enterAttributes(ProgramParser.AttributesContext ctx) {
    }

    @Override
    public void exitAttributes(ProgramParser.AttributesContext ctx) {
    }

    @Override
    public void enterAttribute(ProgramParser.AttributeContext ctx) {
        this.enter();
        this.dirs.add((Object)"o").attr((Object)"line", (Object)ctx.getStart().getLine());
    }

    @Override
    public void exitAttribute(ProgramParser.AttributeContext ctx) {
        this.dirs.up().up();
    }

    @Override
    public void enterLabel(ProgramParser.LabelContext ctx) {
        if (ctx.AT() != null) {
            this.dirs.attr((Object)"name", (Object)ctx.AT().getText());
        }
        if (ctx.NAME() != null) {
            this.dirs.attr((Object)"name", (Object)ctx.NAME().getText());
        }
        if (ctx.DOTS() != null) {
            this.dirs.attr((Object)"vararg", (Object)"");
        }
    }

    @Override
    public void exitLabel(ProgramParser.LabelContext ctx) {
    }

    @Override
    public void enterTail(ProgramParser.TailContext ctx) {
        this.enter();
    }

    @Override
    public void exitTail(ProgramParser.TailContext ctx) {
        this.dirs.up();
    }

    @Override
    public void enterSuffix(ProgramParser.SuffixContext ctx) {
        this.enter();
        if (ctx.CONST() != null) {
            this.dirs.attr((Object)"const", (Object)"");
        }
    }

    @Override
    public void exitSuffix(ProgramParser.SuffixContext ctx) {
        this.dirs.up();
    }

    @Override
    public void enterMethod(ProgramParser.MethodContext ctx) {
        this.dirs.add((Object)"o").attr((Object)"method", (Object)"").attr((Object)"line", (Object)ctx.getStart().getLine()).attr((Object)"base", (Object)ctx.getText()).up();
    }

    @Override
    public void exitMethod(ProgramParser.MethodContext ctx) {
    }

    @Override
    public void enterHead(ProgramParser.HeadContext ctx) {
        this.dirs.add((Object)"o").attr((Object)"line", (Object)ctx.getStart().getLine());
        if (ctx.NAME() != null) {
            String base = ctx.NAME().getText();
            if (ctx.DOT() != null) {
                base = String.format(".%s", base);
            }
            this.dirs.attr((Object)"base", (Object)base);
        }
        if (ctx.AT() != null) {
            this.dirs.attr((Object)"base", (Object)"@");
        }
        if (ctx.SELF() != null) {
            this.dirs.attr((Object)"base", (Object)"$");
        }
        if (ctx.STAR() != null) {
            this.dirs.attr((Object)"base", (Object)"array").attr((Object)"data", (Object)"array");
        }
        if (ctx.PARENT() != null) {
            this.dirs.attr((Object)"base", (Object)"^");
        }
    }

    @Override
    public void exitHead(ProgramParser.HeadContext ctx) {
        this.dirs.up();
    }

    @Override
    public void enterHas(ProgramParser.HasContext ctx) {
        this.enter();
        this.dirs.attr((Object)"as", (Object)ctx.NAME().getText());
    }

    @Override
    public void exitHas(ProgramParser.HasContext ctx) {
        this.dirs.up();
    }

    @Override
    public void enterApplication(ProgramParser.ApplicationContext ctx) {
    }

    @Override
    public void exitApplication(ProgramParser.ApplicationContext ctx) {
    }

    @Override
    public void enterHtail(ProgramParser.HtailContext ctx) {
        this.enter();
    }

    @Override
    public void exitHtail(ProgramParser.HtailContext ctx) {
        this.dirs.up();
    }

    @Override
    public void enterData(ProgramParser.DataContext ctx) {
        String data;
        String type;
        String text = ctx.getText();
        if (ctx.BYTES() != null) {
            type = "bytes";
            data = text.replace("-", " ").trim();
        } else if (ctx.BOOL() != null) {
            type = "bool";
            data = Boolean.toString(Boolean.parseBoolean(text));
        } else if (ctx.CHAR() != null) {
            type = "char";
            data = text.substring(1, 2);
        } else if (ctx.FLOAT() != null) {
            type = "float";
            data = Double.toString(Double.parseDouble(text));
        } else if (ctx.INT() != null) {
            type = "int";
            data = Long.toString(Long.parseLong(text));
        } else if (ctx.REGEX() != null) {
            type = "regex";
            data = text.substring(1, text.lastIndexOf(47));
            this.dirs.attr((Object)"flags", (Object)text.substring(text.lastIndexOf(47) + 1));
        } else if (ctx.HEX() != null) {
            type = "int";
            data = Long.toString(Long.parseLong(text.substring(2), 16));
        } else if (ctx.STRING() != null) {
            type = "string";
            data = text.substring(1, text.length() - 1);
        } else {
            throw new ParsingException("Unknown data type");
        }
        this.dirs.attr((Object)"data", (Object)type);
        this.dirs.attr((Object)"base", (Object)type);
        this.dirs.set((Object)data);
    }

    @Override
    public void exitData(ProgramParser.DataContext ctx) {
    }

    public void visitTerminal(TerminalNode node) {
    }

    public void visitErrorNode(ErrorNode node) {
        throw new ParsingException(node.getText());
    }

    public void enterEveryRule(ParserRuleContext ctx) {
    }

    public void exitEveryRule(ParserRuleContext ctx) {
    }

    private void enter() {
        this.dirs.xpath((Object)"o[last()]").strict(1);
    }
}

