/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.indexes;

import org.xBaseJ.indexes.NodeFloat;

public class NodeKey {
    char type = (char)32;
    Object key;

    public NodeKey(Object keyIn) {
        if (keyIn instanceof String) {
            this.type = (char)67;
        } else if (keyIn instanceof Double) {
            this.type = (char)78;
        } else if (keyIn instanceof NodeFloat) {
            this.type = (char)70;
        }
        this.key = keyIn;
    }

    public char getType() {
        return this.type;
    }

    public String rebuildString(String inString) {
        char[] a = new char[inString.length()];
        for (int i = 0; i < inString.length(); ++i) {
            a[i] = inString.charAt(i) == '_' ? 31 : inString.charAt(i);
        }
        return new String(a);
    }

    public int compareKey(NodeKey keyCompareTo) {
        int ret = 0;
        if (this.type != keyCompareTo.getType()) {
            return -1;
        }
        if (this.type == 'C') {
            String s = (String)this.key;
            s = this.rebuildString(s);
            String t = keyCompareTo.toString();
            t = this.rebuildString(t);
            return s.compareTo(t);
        }
        if (this.type == 'F') {
            NodeFloat nf = (NodeFloat)this.key;
            NodeFloat nft = (NodeFloat)keyCompareTo.key;
            return nf.compareTo(nft);
        }
        Double d = (Double)this.key;
        double d2 = d - keyCompareTo.toDouble();
        if (d2 < 0.0) {
            return -1;
        }
        if (d2 > 0.0) {
            return 1;
        }
        return ret;
    }

    public int length() {
        if (this.type == 'C') {
            return ((String)this.key).length();
        }
        if (this.type == 'F') {
            return 12;
        }
        return 8;
    }

    public String toString() {
        return this.key.toString();
    }

    public double toDouble() {
        if (this.type == 'N') {
            Double d = (Double)this.key;
            return d;
        }
        return 0.0;
    }

    public NodeFloat toNodeFloat() {
        if (this.type == 'F') {
            NodeFloat f = (NodeFloat)this.key;
            return f;
        }
        return null;
    }
}

