/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ;

import java.io.CharArrayWriter;
import java.io.FileReader;
import java.io.IOException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xBaseJ.DBF;
import org.xBaseJ.fields.CharField;
import org.xBaseJ.fields.DateField;
import org.xBaseJ.fields.Field;
import org.xBaseJ.fields.FloatField;
import org.xBaseJ.fields.LogicalField;
import org.xBaseJ.fields.MemoField;
import org.xBaseJ.fields.NumField;
import org.xBaseJ.fields.PictureField;
import org.xBaseJ.xBaseJException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XBaseXmlParser
extends DefaultHandler {
    private SAXParser parser;
    private CharArrayWriter contents = new CharArrayWriter();
    private int iLine = 0;
    private int iElement = 0;
    private boolean recordProcessing = false;
    private DBF dbf;
    private Field fld;
    private String fldName;
    private char fldType;

    public static void main(String[] args) {
        new XBaseXmlParser().parse(args[0]);
    }

    public XBaseXmlParser() {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setValidating(true);
            parserFactory.setNamespaceAware(false);
            this.parser = parserFactory.newSAXParser();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void parse(String inXMLFile) {
        try {
            FileReader fr = new FileReader(inXMLFile);
            InputSource is = new InputSource(fr);
            this.parser.parse(is, (DefaultHandler)this);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        ++this.iElement;
        this.contents.reset();
        try {
            if (rawName.compareTo("dbf") == 0) {
                String dbfName = attributes.getValue("name");
                String dbfEncoding = attributes.getValue("encoding");
                this.dbf = dbfEncoding.length() == 0 ? new DBF(dbfName, true) : new DBF(dbfName, true, dbfEncoding);
            } else if (rawName.compareTo("field") == 0) {
                this.fldName = attributes.getValue("name");
                if (!this.recordProcessing) {
                    this.fldType = attributes.getValue("type").charAt(0);
                    switch (this.fldType) {
                        case 'C': {
                            int fl = Integer.parseInt(attributes.getValue("length"));
                            this.dbf.addField(new CharField(this.fldName, fl));
                            break;
                        }
                        case 'D': {
                            this.dbf.addField(new DateField(this.fldName));
                            break;
                        }
                        case 'F': {
                            int fl = Integer.parseInt(attributes.getValue("length"));
                            int dp = Integer.parseInt(attributes.getValue("decimalPos"));
                            this.dbf.addField(new FloatField(this.fldName, fl, dp));
                            break;
                        }
                        case 'N': {
                            int fl = Integer.parseInt(attributes.getValue("length"));
                            int dp = Integer.parseInt(attributes.getValue("decimalPos"));
                            this.dbf.addField(new NumField(this.fldName, fl, dp));
                            break;
                        }
                        case 'L': {
                            this.dbf.addField(new LogicalField(this.fldName));
                            break;
                        }
                        case 'M': {
                            this.dbf.addField(new MemoField(this.fldName));
                            break;
                        }
                        case 'P': {
                            this.dbf.addField(new PictureField(this.fldName));
                        }
                    }
                } else {
                    this.fld = this.dbf.getField(this.fldName);
                }
            } else if (rawName.compareTo("record") == 0) {
                this.recordProcessing = true;
            } else {
                System.err.println("Logic error: Unknown element name \"" + rawName + "\" found at element position " + this.iElement + " line: " + this.iLine);
            }
        }
        catch (xBaseJException xbe) {
            throw new SAXException("org.xBaseJ error: " + xbe.getMessage());
        }
        catch (IOException ioe) {
            throw new SAXException("java.IOExcpetion: " + ioe.getMessage());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String rawName) throws SAXException {
        String data = this.contents.toString();
        try {
            if (rawName.compareTo("dbf") != 0) {
                if (rawName.compareTo("field") == 0) {
                    if (this.recordProcessing) {
                        this.fld.put(data);
                    }
                } else if (rawName.compareTo("record") == 0) {
                    this.dbf.write();
                }
            }
        }
        catch (xBaseJException xbe) {
            throw new SAXException("org.xBaseJ error: " + xbe.getMessage());
        }
        catch (IOException ioe) {
            throw new SAXException("java.IOExcpetion: " + ioe.getMessage());
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            if (ch[i] != '\n') continue;
            ++this.iLine;
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        System.err.println("Warning at (file " + e.getSystemId() + ", line " + e.getLineNumber() + ", char " + e.getColumnNumber() + "): " + e.getMessage());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw new SAXException("Error at (file " + e.getSystemId() + ", line " + e.getLineNumber() + ", char " + e.getColumnNumber() + "): " + e.getMessage());
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException("Fatal Error at (file " + e.getSystemId() + ", line " + e.getLineNumber() + ", char " + e.getColumnNumber() + "): " + e.getMessage());
    }
}

