/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xBaseJ.fields.DateField;

public class DbaseUtils {
    private static final Logger logger = LoggerFactory.getLogger(DbaseUtils.class);
    private static Properties props = new Properties();
    private static File propFile = null;
    private static InputStream propIS = null;
    private static long lastUpdate = -1L;
    private static boolean recheckProperties;

    public static long x86(long in) {
        if (System.getProperty("os.arch").indexOf("86") == 0 && System.getProperty("os.arch").compareTo("vax") != 0) {
            return in;
        }
        boolean negative = false;
        long save = in;
        if (in < 0L) {
            negative = true;
        }
        long first = in >>> 56;
        if (negative) {
            first = (byte)in & 0x7F;
        }
        if (negative) {
            first |= 0x80L;
        }
        long isnt = first << 56;
        save = in - isnt;
        long second = save >>> 48;
        isnt = second << 48;
        long third = (save -= isnt) >>> 40;
        isnt = third << 40;
        long fourth = (save -= isnt) >>> 32;
        isnt = fourth << 32;
        long fifth = (save -= isnt) >>> 24;
        isnt = fifth << 24;
        long sixth = (save -= isnt) >>> 16;
        isnt = sixth << 16;
        long seventh = (save -= isnt) >>> 8;
        isnt = seventh << 8;
        long eigth = save -= isnt;
        long is = (eigth << 56) + (seventh << 48) + (sixth << 40) + (fifth << 32) + (fourth << 24) + (third << 16) + (second << 8) + first;
        return is;
    }

    public static int x86(int in) {
        if (System.getProperty("os.arch").indexOf("86") == 0 && System.getProperty("os.arch").compareTo("vax") != 0) {
            return in;
        }
        boolean negative = false;
        int save = in;
        if (in < 0) {
            negative = true;
            in &= Integer.MAX_VALUE;
        }
        int first = in >>> 24;
        if (negative) {
            first |= 0x80;
        }
        in = save & 0xFF0000;
        int second = in >>> 16;
        in = save & 0xFF00;
        int third = in >>> 8;
        int fourth = save & 0xFF;
        int is = (fourth << 24) + (third << 16) + (second << 8) + first;
        return is;
    }

    public static short x86(short in) {
        if (System.getProperty("os.arch").indexOf("86") == 0 && System.getProperty("os.arch").compareTo("vax") != 0) {
            return in;
        }
        short save = in;
        boolean negative = false;
        if (in < 0) {
            negative = true;
            in = (short)(in & Short.MAX_VALUE);
        }
        int first = in >>> 8;
        if (negative) {
            first |= 0x80;
        }
        int second = save & 0xFF;
        short is = (short)((second << 8) + first);
        return is;
    }

    public static double doubleDate(DateField d) {
        return DbaseUtils.doubleDate(d.get());
    }

    public static double doubleDate(String s) {
        if (s.trim().length() == 0) {
            return 1.0E100;
        }
        int year = Integer.parseInt(s.substring(0, 4));
        if (year == 0) {
            return 1.0E100;
        }
        int[] days = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int month = Integer.parseInt(s.substring(4, 6));
        int day = Integer.parseInt(s.substring(6, 8));
        int daydif = 2378497;
        if (year / 4 == 0) {
            days[2] = 29;
        }
        if (year > 1799) {
            daydif += day - 1;
            for (int i = 2; i <= month; ++i) {
                daydif += days[i - 1];
            }
            daydif += (year - 1800) * 365;
            daydif += (year - 1800) / 4;
            daydif -= (year - 1800) % 100;
            if (year > 1999) {
                ++daydif;
            }
        } else {
            daydif -= days[month] - day + 1;
            for (int i = 11; i >= month; --i) {
                daydif -= days[i + 1];
            }
            daydif -= (1799 - year) * 365;
            daydif -= (1799 - year) / 4;
        }
        Integer retInt = new Integer(daydif);
        return retInt.doubleValue();
    }

    public static String normalize(String inString) {
        StringBuffer sb = new StringBuffer();
        block7: for (int i = 0; i < inString.length(); ++i) {
            switch (inString.charAt(i)) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    if (inString.charAt(i) < ' ') {
                        sb.append(inString.charAt(i) + 60928);
                        continue block7;
                    }
                    sb.append(inString.charAt(i));
                }
            }
        }
        return new String(sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getxBaseJProperty(String inString) throws IOException {
        Properties properties = props;
        synchronized (properties) {
            String rets;
            if (propFile == null && propIS == null) {
                propIS = DbaseUtils.getPropertiesFile();
                if (propFile != null) {
                    lastUpdate = propFile.lastModified();
                    logger.debug("loading properties");
                    props.load(propIS);
                }
            } else if (propFile != null && recheckProperties && lastUpdate < propFile.lastModified()) {
                props = new Properties();
                propIS = new FileInputStream(propFile);
                lastUpdate = propFile.lastModified();
                logger.debug("loading properties, because modified");
                props.load(propIS);
            }
            rets = (rets = props.getProperty(inString)) != null ? rets.trim() : "";
            return rets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setxBaseJProperty(String inName, String inValue) throws IOException {
        Properties properties = props;
        synchronized (properties) {
            props.put(inName, inValue);
        }
    }

    public static boolean dontTrimFields() {
        String prop;
        try {
            prop = DbaseUtils.getxBaseJProperty("trimFields");
        }
        catch (IOException e) {
            return false;
        }
        if (prop.toLowerCase().compareTo("yes") == 0) {
            return true;
        }
        return prop.toLowerCase().compareTo("true") == 0;
    }

    public static boolean fieldFilledWithSpaces() {
        String prop;
        try {
            prop = DbaseUtils.getxBaseJProperty("fieldFilledWithSpaces");
        }
        catch (IOException e) {
            return false;
        }
        if (prop.toLowerCase().compareTo("yes") == 0) {
            return true;
        }
        return prop.toLowerCase().compareTo("true") == 0;
    }

    private static InputStream getPropertiesFile() {
        File f1;
        String xBaseJPropertiesFileName = "org.xBaseJ.properties";
        String _fileName = System.getProperty(xBaseJPropertiesFileName);
        if (_fileName != null) {
            xBaseJPropertiesFileName = _fileName;
        }
        if ((f1 = new File(xBaseJPropertiesFileName)).exists()) {
            try {
                propFile = f1;
                if (logger.isDebugEnabled()) {
                    logger.debug("properties file loaded from {}", (Object)f1.getAbsolutePath());
                }
                return new FileInputStream(f1);
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                return null;
            }
        }
        xBaseJPropertiesFileName = System.getProperty("user.home") + "/org.xBaseJ.properties";
        File f2 = new File(xBaseJPropertiesFileName);
        if (f2.exists()) {
            try {
                propFile = f2;
                if (logger.isDebugEnabled()) {
                    logger.debug("properties file loaded from {}", (Object)f2.getAbsolutePath());
                }
                return new FileInputStream(f2);
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                return null;
            }
        }
        xBaseJPropertiesFileName = System.getProperty("java.home") + "/org.xBaseJ.properties";
        File f3 = new File(xBaseJPropertiesFileName);
        if (f3.exists()) {
            try {
                propFile = f3;
                if (logger.isDebugEnabled()) {
                    logger.debug("properties file loaded from {}", (Object)f3.getAbsolutePath());
                }
                return new FileInputStream(f3);
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                return null;
            }
        }
        InputStream is = new DbaseUtils().getClass().getResourceAsStream("/org.xBaseJ.properties");
        if (is == null) {
            is = ClassLoader.getSystemClassLoader().getResourceAsStream("org.xBaseJ.properties");
        }
        if (is != null) {
            logger.debug("properties file loaded from classpath");
            return is;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Searched for org.xBaseJ.properties as {}", (Object)f1.getAbsolutePath());
            logger.debug("Searched for org.xBaseJ.properties as {}", (Object)f2.getAbsolutePath());
            logger.debug("Searched for org.xBaseJ.properties as {}", (Object)f3.getAbsolutePath());
            logger.debug("Searched for org.xBaseJ.properties in classpath environment variable");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closexBaseJProperty() {
        Properties properties = props;
        synchronized (properties) {
            propFile = null;
            if (propIS != null) {
                try {
                    propIS.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                propIS = null;
            }
            props = new Properties();
        }
    }

    public static void copyFile(String inputFile, String outputFile) throws IOException {
        FileInputStream fis = new FileInputStream(inputFile);
        FileOutputStream fos = new FileOutputStream(outputFile);
        int b = fis.read();
        while (b != -1) {
            fos.write(b);
            b = fis.read();
        }
        fos.close();
        fis.close();
    }

    public static boolean useSharedLocks() {
        String usl;
        try {
            usl = DbaseUtils.getxBaseJProperty("useSharedLocks").toLowerCase();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            usl = "false";
        }
        return usl.compareTo("true") == 0;
    }

    static {
        try {
            String test = DbaseUtils.getxBaseJProperty("checkPropertyFileForChanges");
            if (test.length() > 0) {
                recheckProperties = test.compareToIgnoreCase("true") == 0 || test.compareToIgnoreCase("yes") == 0;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            logger.debug("recheckProperties is {}", (Object)recheckProperties);
        }
    }
}

