/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.indexes;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.xBaseJ.DBF;
import org.xBaseJ.DbaseUtils;
import org.xBaseJ.indexes.MDXFile;
import org.xBaseJ.indexes.Node;
import org.xBaseJ.indexes.NodeFloat;
import org.xBaseJ.indexes.NodeKey;
import org.xBaseJ.xBaseJException;

public class MNode
extends Node {
    int prev_page = 0;
    MDXFile mfile;

    public MNode(MDXFile file, int keys_in, int key_size, char keyType, int rn, boolean iBranch) {
        super(file.getRandomAccessFile(), keys_in, key_size, keyType, rn, iBranch);
        this.mfile = file;
    }

    @Override
    public void read() throws IOException {
        long longrecn = this.record_number;
        this.nfile.seek(longrecn * 512L);
        this.keys_in_this_Node = DbaseUtils.x86(this.nfile.readInt());
        this.prev_page = DbaseUtils.x86(this.nfile.readInt());
        this.branch = this.prev_page != 0;
        byte[] b = new byte[12];
        for (int i = 0; i < this.keys_in_a_Node; ++i) {
            int k;
            this.key_record_number[i] = DbaseUtils.x86(this.nfile.readInt());
            if (this.keyType == 'F') {
                this.nfile.read(b);
                this.key_expression[i] = i < this.keys_in_this_Node ? new NodeKey(new NodeFloat(b)) : new NodeKey(new NodeFloat(0.0));
            } else if (this.keyType == 'N') {
                this.key_expression[i] = new NodeKey(new Double(Double.longBitsToDouble(this.nfile.readLong())));
            } else {
                this.nfile.readFully(this.key_buffer, 0, this.key_expression_size);
                for (k = 0; k < this.key_expression_size && this.key_buffer[k] != 0; ++k) {
                }
                try {
                    this.key_expression[i] = new NodeKey(new String(this.key_buffer, 0, k, DBF.encodedType));
                }
                catch (UnsupportedEncodingException UEE) {
                    this.key_expression[i] = new NodeKey(new String(this.key_buffer, 0, k));
                }
            }
            int j = this.key_expression_size % 4;
            if (j > 0) {
                j = 4 - j;
            }
            for (k = 0; k < j; ++k) {
                this.nfile.readByte();
            }
        }
        this.key_record_number[i] = DbaseUtils.x86(this.nfile.readInt());
        this.branch = this.key_record_number[this.keys_in_this_Node] > 0;
    }

    @Override
    public void write() throws IOException, xBaseJException {
        int i;
        long longrecn = this.record_number;
        this.nfile.seek(longrecn * 512L);
        int ll = this.mfile.getAnchor().get_blockbytes();
        this.nfile.writeInt(DbaseUtils.x86(this.keys_in_this_Node));
        ll -= 4;
        this.nfile.writeInt(DbaseUtils.x86(this.prev_page));
        ll -= 4;
        for (i = 0; i < this.keys_in_a_Node && this.key_expression[i] != null; ++i) {
            if (this.key_expression[i] == null) {
                throw new xBaseJException("Missing Node Key expression at " + i);
            }
            if (this.branch && i <= this.keys_in_this_Node || !this.branch && i < this.keys_in_this_Node) {
                this.nfile.writeInt(DbaseUtils.x86(this.key_record_number[i]));
            } else {
                this.nfile.writeInt(0);
            }
            ll -= 4;
            int j = 0;
            ll -= this.key_expression_size;
            if (this.key_expression[i].getType() == 'F') {
                this.nfile.write(this.key_expression[i].toNodeFloat().getValue());
            } else if (this.key_expression[i].getType() == 'N') {
                double d = this.key_expression[i].toDouble();
                this.nfile.writeLong(Double.doubleToLongBits(d));
            } else {
                int x;
                byte[] bytebuffer;
                try {
                    bytebuffer = this.key_expression[i].toString().getBytes(DBF.encodedType);
                }
                catch (UnsupportedEncodingException UEE) {
                    bytebuffer = this.key_expression[i].toString().getBytes();
                }
                for (x = 0; x < bytebuffer.length; ++x) {
                    this.key_buffer[x] = bytebuffer[x];
                }
                while (x < this.key_expression_size) {
                    this.key_buffer[x] = 0;
                    ++x;
                }
                this.nfile.write(this.key_buffer, 0, this.key_expression_size);
                j = this.key_expression_size % 4;
                if (j > 0) {
                    j = 4 - j;
                }
            }
            this.key_buffer[0] = 0;
            for (int k = 0; k < j; ++k) {
                this.nfile.write(this.key_buffer[0]);
            }
            ll -= j;
        }
        if (this.branch) {
            this.nfile.writeInt(DbaseUtils.x86(this.key_record_number[i]));
        } else {
            this.nfile.writeInt(0);
        }
        if ((ll -= 4) > 0) {
            byte[] temp = new byte[ll];
            this.nfile.write(temp, 0, ll);
        }
    }

    @Override
    public void set_lower_level(int level) {
        if (this.branch) {
            this.key_record_number[this.pos] = level;
        }
    }

    @Override
    public int get_lower_level() {
        if (this.branch) {
            return this.key_record_number[this.pos];
        }
        return 0;
    }

    public int get_prev_page() {
        return this.prev_page;
    }

    @Override
    public void set_prev_page(int pp) {
        this.prev_page = pp;
    }
}

