/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.xBaseJ.DBF;
import org.xBaseJ.DBTFile;
import org.xBaseJ.DbaseUtils;
import org.xBaseJ.xBaseJException;

public class DBT_iii
extends DBTFile {
    public DBT_iii(DBF iDBF, boolean readOnly) throws IOException, xBaseJException {
        super(iDBF, readOnly, -125);
    }

    public DBT_iii(DBF iDBF, String name, boolean destroy) throws IOException, xBaseJException {
        super(iDBF, name, destroy, -125);
    }

    @Override
    public void setNextBlock() throws IOException {
        if (this.file.length() == 0L) {
            this.file.writeInt(DbaseUtils.x86(1));
            this.nextBlock = 1;
            this.file.seek(511L);
            this.file.writeByte(0);
        } else {
            this.nextBlock = DbaseUtils.x86(this.file.readInt());
        }
    }

    @Override
    public byte[] readBytes(byte[] input) throws IOException, xBaseJException {
        byte[] bTemp = new byte[513];
        boolean work = true;
        boolean onefound = false;
        byte[] bTemp2 = null;
        byte[] bTemp3 = null;
        int workLength = 0;
        for (int i = 0; i < 10 && (input[i] < 48 || input[i] > 57); ++i) {
            input[i] = 48;
        }
        String sPos = new String(input, 0, 10);
        long lPos = Long.parseLong(sPos);
        if (lPos == 0L) {
            return null;
        }
        this.file.seek(lPos * (long)this.memoBlockSize);
        do {
            int i;
            this.file.read(bTemp, 0, this.memoBlockSize);
            for (i = 0; i < this.memoBlockSize; ++i) {
                if (bTemp[i] == 26) {
                    if (onefound) {
                        work = false;
                        bTemp[i] = 0;
                        --i;
                        break;
                    }
                    work = false;
                    onefound = true;
                    break;
                }
                if (bTemp[i] == 0) {
                    if (onefound) {
                        work = false;
                        break;
                    }
                    onefound = false;
                    continue;
                }
                onefound = false;
            }
            if (workLength > 0) {
                bTemp3 = new byte[workLength];
                System.arraycopy(bTemp2, 0, bTemp3, 0, workLength);
            }
            bTemp2 = new byte[workLength + i];
            if (workLength > 0) {
                System.arraycopy(bTemp3, 0, bTemp2, 0, workLength);
            }
            System.arraycopy(bTemp, 0, bTemp2, workLength, i);
            if ((long)(workLength += i) <= this.file.length()) continue;
            throw new xBaseJException("error reading dtb file, reading exceeds length of file");
        } while (work);
        return bTemp2;
    }

    @Override
    public byte[] write(String value, int originalSize, boolean write, byte[] originalPos) throws IOException, xBaseJException {
        int pos;
        long startPos;
        byte[] buffer = new byte[512];
        if (value.length() == 0) {
            byte[] breturn = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48};
            return breturn;
        }
        boolean madebigger = originalSize == 0 && value.length() > 0 ? true : value.length() / this.memoBlockSize + 1 > originalSize / this.memoBlockSize + 1;
        if (madebigger || write) {
            startPos = this.nextBlock;
            this.nextBlock += (value.length() + 2) / this.memoBlockSize + 1;
        } else {
            String sPos = new String(originalPos, 0, 10);
            startPos = Long.parseLong(sPos);
        }
        this.file.seek(startPos * (long)this.memoBlockSize);
        for (pos = 0; pos < value.length(); pos += this.memoBlockSize) {
            byte[] b;
            if (pos + this.memoBlockSize > value.length()) {
                try {
                    b = value.substring(pos, value.length()).getBytes(DBF.encodedType);
                }
                catch (UnsupportedEncodingException UEE) {
                    b = value.substring(pos, value.length()).getBytes();
                }
            } else {
                try {
                    b = value.substring(pos, pos + this.memoBlockSize).getBytes(DBF.encodedType);
                }
                catch (UnsupportedEncodingException UEE) {
                    b = value.substring(pos, pos + this.memoBlockSize).getBytes();
                }
            }
            for (int x = 0; x < b.length; ++x) {
                buffer[x] = b[x];
            }
            this.file.write(buffer, 0, 512);
        }
        this.file.seek(startPos * (long)this.memoBlockSize + (long)value.length());
        this.file.writeByte(26);
        this.file.writeByte(26);
        if (madebigger || write) {
            this.file.seek(this.memoBlockSize * this.nextBlock - 1);
            this.file.writeByte(26);
            this.file.seek(0L);
            this.file.writeInt(DbaseUtils.x86(this.nextBlock));
        }
        String returnString = new String(Long.toString(startPos));
        byte[] ten = new byte[10];
        byte[] newTen = new byte[10];
        newTen = returnString.getBytes();
        for (pos = 0; pos < 10 - returnString.length(); ++pos) {
            ten[pos] = 48;
        }
        int x = 0;
        while (pos < 10) {
            ten[pos] = newTen[x];
            ++pos;
            ++x;
        }
        return ten;
    }
}

