/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Calendar;
import java.util.Vector;
import org.xBaseJ.DBTFile;
import org.xBaseJ.DBT_fpt;
import org.xBaseJ.DBT_iii;
import org.xBaseJ.DBT_iv;
import org.xBaseJ.DbaseUtils;
import org.xBaseJ.fields.CharField;
import org.xBaseJ.fields.DateField;
import org.xBaseJ.fields.Field;
import org.xBaseJ.fields.FloatField;
import org.xBaseJ.fields.LogicalField;
import org.xBaseJ.fields.MemoField;
import org.xBaseJ.fields.NumField;
import org.xBaseJ.fields.PictureField;
import org.xBaseJ.indexes.Index;
import org.xBaseJ.indexes.MDX;
import org.xBaseJ.indexes.MDXFile;
import org.xBaseJ.indexes.NDX;
import org.xBaseJ.xBaseJException;

public class DBF
implements Closeable {
    public static final String xBaseJVersion = "2.1.R";
    public static final byte DBASEIII = 3;
    public static final byte DBASEIV = 4;
    public static final byte DBASEIII_WITH_MEMO = -125;
    public static final byte DBASEIV_WITH_MEMO = -117;
    public static final byte FOXPRO_WITH_MEMO = -11;
    public static final byte NOTDELETED = 32;
    public static final byte DELETED = 42;
    public static final char READ_ONLY = 'r';
    public static String encodedType = "8859_1";
    private String dosname;
    private int current_record = 0;
    private short fldcount = 0;
    private File ffile;
    private RandomAccessFile file;
    private Vector<Field> fld_root;
    private DBTFile dbtobj = null;
    private byte delete_ind = (byte)32;
    private byte version = (byte)3;
    private byte[] l_update = new byte[3];
    private int count = 0;
    private short offset = 0;
    private short lrecl = 0;
    private byte incomplete_transaction = 0;
    private byte encrypt_flag = 0;
    private byte[] reserve = new byte[12];
    private byte MDX_exist = 0;
    private byte language = 0;
    private byte[] reserve2 = new byte[2];
    private Index jNDX;
    private Vector<Index> jNDXes;
    private Vector<String> jNDXID;
    private MDXFile MDXfile = null;
    private boolean readonly = false;
    private FileChannel channel = null;
    private FileLock filelock = null;
    private FileLock recordlock = null;
    private long fileLockWait = 5000L;
    private ByteBuffer buffer;
    private boolean useSharedLocks = DbaseUtils.useSharedLocks();

    public static final String version() {
        return xBaseJVersion;
    }

    public DBF(String DBFname, boolean destroy) throws xBaseJException, IOException, SecurityException {
        this.createDBF(DBFname, 3, destroy);
    }

    public DBF(String DBFname, int format, boolean destroy) throws xBaseJException, IOException, SecurityException {
        this.createDBF(DBFname, format, destroy);
    }

    public DBF(String DBFname, char readOnly) throws xBaseJException, IOException {
        if (readOnly != 'r') {
            throw new xBaseJException("Unknown readOnly indicator <" + readOnly + ">");
        }
        this.readonly = true;
        this.openDBF(DBFname);
    }

    public DBF(String DBFname) throws xBaseJException, IOException {
        this.readonly = false;
        this.openDBF(DBFname);
    }

    public DBF(String DBFname, boolean destroy, String inEncodeType) throws xBaseJException, IOException, SecurityException {
        DBF.setEncodingType(inEncodeType);
        this.createDBF(DBFname, 3, destroy);
    }

    public DBF(String DBFname, int format, boolean destroy, String inEncodeType) throws xBaseJException, IOException, SecurityException {
        DBF.setEncodingType(inEncodeType);
        this.createDBF(DBFname, format, destroy);
    }

    public DBF(String DBFname, char readOnly, String inEncodeType) throws xBaseJException, IOException {
        if (readOnly != 'r') {
            throw new xBaseJException("Unknown readOnly indicator <" + readOnly + ">");
        }
        this.readonly = true;
        DBF.setEncodingType(inEncodeType);
        this.openDBF(DBFname);
    }

    public DBF(String DBFname, String inEncodeType) throws xBaseJException, IOException {
        this.readonly = false;
        DBF.setEncodingType(inEncodeType);
        this.openDBF(DBFname);
    }

    protected void openDBF(String DBFname) throws IOException, xBaseJException {
        int i;
        this.jNDX = null;
        this.jNDXes = new Vector(1);
        this.jNDXID = new Vector(1);
        this.ffile = new File(DBFname);
        if (!this.ffile.exists() || !this.ffile.isFile()) {
            throw new xBaseJException("Unknown database file " + DBFname);
        }
        this.file = this.readonly ? new RandomAccessFile(DBFname, "r") : new RandomAccessFile(DBFname, "rw");
        this.dosname = DBFname;
        this.channel = this.file.getChannel();
        this.read_dbhead();
        this.buffer = ByteBuffer.allocateDirect(this.lrecl + 1);
        this.fldcount = (short)((this.offset - 1) / 32 - 1);
        if (this.version != 3 && this.version != -125 && this.version != 4 && this.version != -117 && this.version != -11) {
            String mismatch = DbaseUtils.getxBaseJProperty("ignoreVersionMismatch").toLowerCase();
            if (mismatch != null && (mismatch.compareTo("true") == 0 || mismatch.compareTo("yes") == 0)) {
                System.err.println("Wrong Version " + String.valueOf(this.version));
            } else {
                throw new xBaseJException("Wrong Version " + String.valueOf(this.version));
            }
        }
        if (this.version == -11) {
            this.dbtobj = new DBT_fpt(this, this.readonly);
        } else if (this.version == -125) {
            this.dbtobj = new DBT_iii(this, this.readonly);
        } else if (this.version == -117) {
            this.dbtobj = new DBT_iv(this, this.readonly);
        }
        this.fld_root = new Vector(new Long(this.fldcount).intValue());
        for (i = 0; i < this.fldcount; ++i) {
            this.fld_root.addElement(this.read_Field_header());
        }
        if (this.MDX_exist == 1) {
            try {
                this.MDXfile = this.readonly ? new MDXFile(this.dosname, this, 'r') : new MDXFile(this.dosname, this, ' ');
                for (i = 0; i < this.MDXfile.getAnchor().getIndexes(); ++i) {
                    this.jNDXes.addElement(this.MDXfile.getMDX(i));
                }
            }
            catch (xBaseJException xbe) {
                String missing = DbaseUtils.getxBaseJProperty("ignoreMissingMDX").toLowerCase();
                if (missing != null && (missing.compareTo("true") == 0 || missing.compareTo("yes") == 0)) {
                    this.MDX_exist = 0;
                }
                System.err.println(xbe.getMessage());
                System.err.println("Processing continues without mdx file");
                this.MDX_exist = 0;
            }
        }
        try {
            this.file.readByte();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.current_record = 0;
    }

    public void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void createDBF(String DBFname, int format, boolean destroy) throws xBaseJException, IOException, SecurityException {
        this.jNDX = null;
        this.jNDXes = new Vector(1);
        this.jNDXID = new Vector(1);
        this.ffile = new File(DBFname);
        if (format != 3 && format != 4 && format != -125 && format != -117 && format != -11) {
            throw new xBaseJException("Invalid format specified");
        }
        if (!destroy && this.ffile.exists()) {
            throw new xBaseJException("File exists, can't destroy");
        }
        if (destroy) {
            if (this.ffile.exists() && !this.ffile.delete()) {
                throw new xBaseJException("Can't delete old DBF file");
            }
            this.ffile = new File(DBFname);
        }
        FileOutputStream tFOS = new FileOutputStream(this.ffile);
        tFOS.close();
        this.file = new RandomAccessFile(DBFname, "rw");
        this.dosname = DBFname;
        this.channel = this.file.getChannel();
        this.buffer = ByteBuffer.allocateDirect(this.lrecl + 1);
        this.fld_root = new Vector(0);
        if (format == 4 || format == -117) {
            this.MDX_exist = 1;
        }
        boolean memoExists = format == -125 || format == -117 || format == -11;
        this.db_offset(format, memoExists);
        this.update_dbhead();
        this.file.writeByte(13);
        this.file.writeByte(26);
        if (this.MDX_exist == 1) {
            this.MDXfile = new MDXFile(DBFname, this, destroy);
        }
    }

    public void addField(Field aField) throws xBaseJException, IOException {
        Field[] bField = new Field[]{aField};
        this.addField(bField);
    }

    public void addField(Field[] aField) throws xBaseJException, IOException {
        Field tField;
        int i;
        int j;
        if (aField.length == 0) {
            throw new xBaseJException("No Fields in array to add");
        }
        if (this.version == 3 && this.MDX_exist == 0 || this.version == -125) {
            if (this.fldcount + aField.length > 128) {
                throw new xBaseJException("Number of fields exceed limit of 128.  New Field count is " + (this.fldcount + aField.length));
            }
        } else if (this.fldcount + aField.length > 255) {
            throw new xBaseJException("Number of fields exceed limit of 255.  New Field count is " + (this.fldcount + aField.length));
        }
        boolean oldMemo = false;
        for (j = 0; j < aField.length; ++j) {
            for (i = 1; i <= this.fldcount; ++i) {
                tField = this.getField(i);
                if (tField instanceof MemoField || tField instanceof PictureField) {
                    oldMemo = true;
                }
                if (!aField[j].getName().equalsIgnoreCase(tField.getName())) continue;
                throw new xBaseJException("Field: " + aField[j].getName() + " already exists.");
            }
        }
        short newRecl = this.lrecl;
        boolean newMemo = false;
        for (j = 1; j <= aField.length; ++j) {
            newRecl = (short)(newRecl + aField[j - 1].getLength());
            if (this.dbtobj == null && (aField[j - 1] instanceof MemoField || aField[j - 1] instanceof PictureField)) {
                newMemo = true;
            }
            if (aField[j - 1] instanceof PictureField) {
                this.version = (byte)-11;
                continue;
            }
            if (!(aField[j - 1] instanceof MemoField) || !((MemoField)aField[j - 1]).isFoxPro()) continue;
            this.version = (byte)-11;
        }
        String ignoreDBFLength = DbaseUtils.getxBaseJProperty("ignoreDBFLengthCheck");
        if ((ignoreDBFLength == null || ignoreDBFLength.toLowerCase().compareTo("true") != 0 && ignoreDBFLength.toLowerCase().compareTo("yes") != 0) && newRecl > 4000) {
            throw new xBaseJException("Record length of 4000 exceeded.  New calculated length is " + newRecl);
        }
        boolean createTemp = false;
        DBF tempDBF = null;
        String newName = "";
        if (this.fldcount > 0) {
            createTemp = true;
        }
        if (createTemp) {
            File f = File.createTempFile("org.xBaseJ", this.ffile.getName());
            newName = f.getName();
            f.delete();
            int format = this.version;
            if (format == 3 && this.MDX_exist == 1) {
                format = 4;
            }
            tempDBF = new DBF(newName, format, true);
            tempDBF.version = (byte)format;
            tempDBF.MDX_exist = this.MDX_exist;
        }
        if (newMemo) {
            if (createTemp) {
                tempDBF.dbtobj = (this.version == 3 || this.version == -125) && this.MDX_exist == 0 ? new DBT_iii(this, newName, true) : (this.version == -11 ? new DBT_fpt(this, newName, true) : new DBT_iv(this, newName, true));
            } else {
                this.dbtobj = (this.version == 3 || this.version == -125) && this.MDX_exist == 0 ? new DBT_iii(this, this.dosname, true) : (this.version == -11 ? new DBT_fpt(this, this.dosname, true) : new DBT_iv(this, this.dosname, true));
            }
        } else if (createTemp && oldMemo) {
            tempDBF.dbtobj = (this.version == 3 || this.version == -125) && this.MDX_exist == 0 ? new DBT_iii(this, newName, true) : (this.version == -11 ? new DBT_fpt(this, newName, true) : new DBT_iv(this, newName, true));
        }
        if (createTemp) {
            tempDBF.db_offset(this.version, newMemo || this.dbtobj != null);
            tempDBF.update_dbhead();
            tempDBF.offset = this.offset;
            tempDBF.lrecl = newRecl;
            tempDBF.fldcount = this.fldcount;
            for (i = 1; i <= this.fldcount; ++i) {
                try {
                    tField = (Field)this.getField(i).clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new xBaseJException("Clone not supported logic error");
                }
                if (tField instanceof MemoField) {
                    ((MemoField)tField).setDBTObj(tempDBF.dbtobj);
                }
                if (tField instanceof PictureField) {
                    ((PictureField)tField).setDBTObj(tempDBF.dbtobj);
                }
                tField.setBuffer(tempDBF.buffer);
                tempDBF.fld_root.addElement(tField);
                tempDBF.write_Field_header(tField);
            }
            for (i = 0; i < aField.length; ++i) {
                aField[i].setBuffer(tempDBF.buffer);
                tempDBF.fld_root.addElement(aField[i]);
                tempDBF.write_Field_header(aField[i]);
                tField = aField[i];
                if (tField instanceof MemoField) {
                    ((MemoField)tField).setDBTObj(tempDBF.dbtobj);
                }
                if (!(tField instanceof PictureField)) continue;
                ((PictureField)tField).setDBTObj(tempDBF.dbtobj);
            }
        } else {
            this.lrecl = newRecl;
            short savefldcnt = this.fldcount;
            this.fldcount = (short)(this.fldcount + aField.length);
            this.offset = (short)(this.offset + 32 * aField.length);
            if (newMemo) {
                if (this.dbtobj instanceof DBT_iii) {
                    this.version = (byte)-125;
                } else if (this.dbtobj instanceof DBT_iv) {
                    this.version = (byte)-117;
                } else if (this.dbtobj instanceof DBT_fpt) {
                    this.version = (byte)-11;
                }
            }
            this.channel = this.file.getChannel();
            this.buffer = ByteBuffer.allocateDirect(this.lrecl + 1);
            this.update_dbhead();
            for (i = 1; i <= savefldcnt; ++i) {
                tField = this.getField(i);
                if (tField instanceof MemoField) {
                    ((MemoField)tField).setDBTObj(this.dbtobj);
                }
                if (tField instanceof PictureField) {
                    ((PictureField)tField).setDBTObj(tempDBF.dbtobj);
                }
                this.write_Field_header(tField);
            }
            for (i = 0; i < aField.length; ++i) {
                aField[i].setBuffer(this.buffer);
                tField = aField[i];
                if (tField instanceof MemoField) {
                    ((MemoField)tField).setDBTObj(this.dbtobj);
                }
                if (tField instanceof PictureField) {
                    ((PictureField)tField).setDBTObj(this.dbtobj);
                }
                this.fld_root.addElement(aField[i]);
                this.write_Field_header(aField[i]);
            }
            this.file.writeByte(13);
            this.file.writeByte(26);
            return;
        }
        tempDBF.file.writeByte(13);
        tempDBF.file.writeByte(26);
        tempDBF.fldcount = (short)(tempDBF.fldcount + aField.length);
        tempDBF.offset = (short)(tempDBF.offset + aField.length * 32);
        tempDBF.update_dbhead();
        tempDBF.close();
        tempDBF = new DBF(newName);
        for (j = 1; j <= this.count; ++j) {
            this.gotoRecord(j);
            for (i = 1; i <= this.fldcount; ++i) {
                Field old1 = this.getField(i);
                Field new1 = tempDBF.getField(i);
                new1.put(old1.get());
            }
            for (i = 0; i < aField.length; ++i) {
                Field new1 = aField[i];
                new1.put("");
            }
            tempDBF.write();
        }
        tempDBF.update_dbhead();
        this.file.close();
        this.ffile.delete();
        if (this.dbtobj != null) {
            this.dbtobj.file.close();
            this.dbtobj.thefile.delete();
        }
        if (tempDBF.dbtobj != null) {
            tempDBF.dbtobj.file.close();
            tempDBF.dbtobj.rename(this.dosname);
            this.dbtobj = (this.version == 3 || this.version == -125) && this.MDX_exist == 0 ? (this.dosname.endsWith("dbf") ? new DBT_iii(this, this.readonly) : new DBT_iii(this, this.dosname, true)) : (this.version == -11 ? (this.dosname.endsWith("dbf") ? new DBT_fpt(this, this.readonly) : new DBT_fpt(this, this.dosname, true)) : (this.dosname.endsWith("dbf") ? new DBT_iv(this, this.readonly) : new DBT_iv(this, this.dosname, true)));
        }
        tempDBF.renameTo(this.dosname);
        this.buffer = ByteBuffer.allocateDirect(tempDBF.buffer.capacity());
        tempDBF = null;
        this.ffile = new File(this.dosname);
        this.file = new RandomAccessFile(this.dosname, "rw");
        this.channel = this.file.getChannel();
        for (i = 0; i < aField.length; ++i) {
            aField[i].setBuffer(this.buffer);
            this.fld_root.addElement(aField[i]);
        }
        this.read_dbhead();
        this.fldcount = (short)((this.offset - 1) / 32 - 1);
        for (i = 1; i <= this.fldcount; ++i) {
            tField = this.getField(i);
            tField.setBuffer(this.buffer);
            if (tField instanceof MemoField) {
                ((MemoField)tField).setDBTObj(this.dbtobj);
            }
            if (!(tField instanceof PictureField)) continue;
            ((PictureField)tField).setDBTObj(this.dbtobj);
        }
    }

    public void renameTo(String newname) throws IOException {
        this.file.close();
        File n = new File(newname);
        boolean b = this.ffile.renameTo(n);
        if (!b) {
            this.copyTo(newname);
            this.ffile.delete();
        }
        this.dosname = newname;
    }

    public void setFileLockWait(long inLongWait) {
        if (inLongWait > -1L) {
            this.fileLockWait = inLongWait;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws IOException, xBaseJException {
        long thisWait = this.fileLockWait / 5L;
        for (long waitloop = this.fileLockWait; waitloop > 0L; waitloop -= thisWait) {
            this.filelock = this.channel.tryLock(0L, this.ffile.length(), this.useSharedLocks);
            if (this.filelock != null) {
                return;
            }
            DBF dBF = this;
            synchronized (dBF) {
                try {
                    this.wait(thisWait);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new xBaseJException("file lock wait timed out");
    }

    public void lockRecord() throws IOException, xBaseJException {
        this.lockRecord(this.getCurrentRecordNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockRecord(int recno) throws IOException, xBaseJException {
        this.unlockRecord();
        long calcpos = this.offset + this.lrecl * (recno - 1);
        long thisWait = this.fileLockWait / 5L;
        for (long waitloop = this.fileLockWait; waitloop > 0L; waitloop -= thisWait) {
            this.recordlock = this.channel.tryLock(calcpos, this.lrecl, this.useSharedLocks);
            if (this.recordlock != null) {
                return;
            }
            DBF dBF = this;
            synchronized (dBF) {
                try {
                    this.wait(thisWait);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new xBaseJException("file lock wait timed out");
    }

    public void unlock() throws IOException {
        if (this.filelock != null) {
            this.filelock.release();
        }
        this.filelock = null;
    }

    public void unlockRecord() throws IOException {
        if (this.recordlock != null) {
            this.recordlock.release();
        }
        this.recordlock = null;
    }

    public void dropField(Field aField) throws xBaseJException, IOException {
        int i;
        for (i = 0; i < this.fldcount; ++i) {
            Field tField = this.getField(i);
            if (aField.getName().equalsIgnoreCase(tField.getName())) break;
        }
        if (i > this.fldcount) {
            throw new xBaseJException("Field: " + aField.getName() + " does not exist.");
        }
    }

    public void changeField(Field oldField, Field newField) throws xBaseJException, IOException {
        Field tField;
        int i;
        for (i = 0; i < this.fldcount; ++i) {
            tField = this.getField(i);
            if (oldField.getName().equalsIgnoreCase(tField.getName())) break;
        }
        if (i > this.fldcount) {
            throw new xBaseJException("Field: " + oldField.getName() + " does not exist.");
        }
        for (int j = 0; j < this.fldcount; ++j) {
            tField = this.getField(j);
            if (!newField.getName().equalsIgnoreCase(tField.getName()) || j == i) continue;
            throw new xBaseJException("Field: " + newField.getName() + " already exists.");
        }
    }

    public int getFieldCount() {
        return this.fldcount;
    }

    public int getRecordCount() {
        return this.count;
    }

    public int getCurrentRecordNumber() {
        return this.current_record;
    }

    public int getIndexCount() {
        return this.jNDXes.size();
    }

    public Index getIndex(int indexPosition) throws xBaseJException {
        if (indexPosition < 1) {
            throw new xBaseJException("Index position too small");
        }
        if (indexPosition > this.jNDXes.size()) {
            throw new xBaseJException("Index position too large");
        }
        return this.jNDXes.elementAt(indexPosition - 1);
    }

    public Index useIndex(String filename) throws xBaseJException, IOException {
        for (int i = 1; i <= this.jNDXes.size(); ++i) {
            Index NDXes = this.jNDXes.elementAt(i - 1);
            if (NDXes.getName().compareTo(filename) != 0) continue;
            this.jNDX = NDXes;
            return this.jNDX;
        }
        this.jNDX = this.readonly ? new NDX(filename, this, 'r') : new NDX(filename, this, ' ');
        this.jNDXes.addElement(this.jNDX);
        return this.jNDX;
    }

    public Index useIndex(String filename, String ID) throws xBaseJException, IOException {
        this.useIndex(filename);
        this.jNDXID.addElement(ID);
        return this.useIndex(filename);
    }

    public Index useIndex(Index ndx) throws xBaseJException, IOException {
        for (int i = 1; i <= this.jNDXes.size(); ++i) {
            Index NDXes = this.jNDXes.elementAt(i - 1);
            if (NDXes != ndx) continue;
            this.jNDX = NDXes;
            return NDXes;
        }
        throw new xBaseJException("Unknown Index " + ndx.getName());
    }

    public Index useIndexByID(String ID) throws xBaseJException {
        for (int i = 1; i <= this.jNDXID.size(); ++i) {
            String NDXes = this.jNDXID.elementAt(i - 1);
            if (NDXes.compareTo(ID) != 0) continue;
            this.jNDX = this.jNDXes.elementAt(i - 1);
            return this.jNDXes.elementAt(i - 1);
        }
        throw new xBaseJException("Unknown Index " + ID);
    }

    public Index useTag(String tagname) throws xBaseJException {
        if (this.MDXfile == null) {
            throw new xBaseJException("No MDX file associated with this database");
        }
        this.jNDX = this.MDXfile.getMDX(tagname);
        return this.jNDX;
    }

    public Index useTag(String tagname, String ID) throws xBaseJException, IOException {
        this.useTag(tagname);
        this.jNDXID.addElement(ID);
        return this.useTag(tagname);
    }

    public Index createIndex(String filename, String index, boolean unique) throws xBaseJException, IOException {
        return this.createIndex(filename, index, false, unique);
    }

    public Index createIndex(String filename, String index, boolean destroy, boolean unique) throws xBaseJException, IOException {
        this.jNDX = new NDX(filename, index, this, destroy, unique);
        this.jNDXes.addElement(this.jNDX);
        return this.jNDX;
    }

    public Index createTag(String tagname, String tagIndex, boolean unique) throws xBaseJException, IOException {
        if (this.MDXfile == null) {
            throw new xBaseJException("No MDX file associated with this database");
        }
        this.jNDX = this.MDXfile.createTag(tagname, tagIndex, unique);
        this.jNDXes.addElement(this.jNDX);
        return (MDX)this.jNDX;
    }

    public boolean find(String keyString, boolean lock) throws xBaseJException, IOException {
        if (this.jNDX == null) {
            throw new xBaseJException("Index not defined");
        }
        int r = this.jNDX.find_entry(keyString);
        if (r < 1) {
            throw new xBaseJException("Record not found");
        }
        if (lock) {
            this.lockRecord(r);
        }
        this.gotoRecord(r);
        return this.jNDX.compareKey(keyString);
    }

    public boolean find(String keyString) throws xBaseJException, IOException {
        return this.find(keyString, false);
    }

    public boolean find(String keyString, int recno, boolean lock) throws xBaseJException, IOException {
        if (this.jNDX == null) {
            throw new xBaseJException("Index not defined");
        }
        int r = this.jNDX.find_entry(keyString, recno);
        if (r < 1) {
            throw new xBaseJException("Record not found");
        }
        if (lock) {
            this.lockRecord();
        }
        this.gotoRecord(r);
        return this.jNDX.compareKey(keyString);
    }

    public boolean find(String keyString, int recno) throws xBaseJException, IOException {
        return this.find(keyString, recno, false);
    }

    public boolean findExact(String keyString, boolean lock) throws xBaseJException, IOException {
        if (this.jNDX == null) {
            throw new xBaseJException("Index not defined");
        }
        int r = this.jNDX.find_entry(keyString);
        if (r < 1) {
            return false;
        }
        if (this.jNDX.didFindFindExact()) {
            if (lock) {
                this.lockRecord();
            }
            this.gotoRecord(r);
        }
        return this.jNDX.didFindFindExact();
    }

    public boolean findExact(String keyString) throws xBaseJException, IOException {
        return this.findExact(keyString, false);
    }

    public void findNext(boolean lock) throws xBaseJException, IOException {
        if (this.jNDX == null) {
            throw new xBaseJException("Index not defined");
        }
        int r = this.jNDX.get_next_key();
        if (r == -1) {
            throw new xBaseJException("End Of File");
        }
        if (lock) {
            this.lockRecord();
        }
        this.gotoRecord(r);
    }

    public void findNext() throws xBaseJException, IOException {
        this.findNext(false);
    }

    public void findPrev(boolean lock) throws xBaseJException, IOException {
        if (this.jNDX == null) {
            throw new xBaseJException("Index not defined");
        }
        int r = this.jNDX.get_prev_key();
        if (r == -1) {
            throw new xBaseJException("Top Of File");
        }
        if (lock) {
            this.lockRecord();
        }
        this.gotoRecord(r);
    }

    public void findPrev() throws xBaseJException, IOException {
        this.findPrev(false);
    }

    public void read(boolean lock) throws xBaseJException, IOException {
        if (this.current_record == this.count) {
            throw new xBaseJException("End Of File");
        }
        ++this.current_record;
        if (lock) {
            this.lockRecord();
        }
        this.gotoRecord(this.current_record);
    }

    public void read() throws xBaseJException, IOException {
        this.read(false);
    }

    public void readPrev(boolean lock) throws xBaseJException, IOException {
        if (this.current_record < 1) {
            throw new xBaseJException("Top Of File");
        }
        --this.current_record;
        if (lock) {
            this.lockRecord();
        }
        this.gotoRecord(this.current_record);
    }

    public void readPrev() throws xBaseJException, IOException {
        this.readPrev(false);
    }

    public void gotoRecord(int recno, boolean lock) throws xBaseJException, IOException {
        int i;
        if (recno > this.count || recno < 1) {
            throw new xBaseJException("Invalid Record Number " + recno);
        }
        this.current_record = recno;
        if (lock) {
            this.lockRecord();
        }
        this.seek(recno - 1);
        this.buffer.clear();
        this.channel.read(this.buffer);
        this.buffer.rewind();
        this.delete_ind = this.buffer.get();
        for (i = 0; i < this.fldcount; ++i) {
            Field tField = this.fld_root.elementAt(i);
            tField.read();
        }
        for (i = 1; i <= this.jNDXes.size(); ++i) {
            Index NDXes = this.jNDXes.elementAt(i - 1);
            NDXes.set_active_key(NDXes.build_key());
        }
    }

    public void gotoRecord(int recno) throws xBaseJException, IOException {
        this.gotoRecord(recno, false);
    }

    public void startTop() throws xBaseJException, IOException {
        if (this.jNDX == null) {
            this.current_record = 0;
        } else {
            this.jNDX.position_at_first();
        }
    }

    public void startBottom() throws xBaseJException, IOException {
        if (this.jNDX == null) {
            this.current_record = this.count + 1;
        } else {
            this.jNDX.position_at_last();
        }
    }

    public void write(boolean lock) throws xBaseJException, IOException {
        Index NDXes;
        int i;
        for (i = 1; i <= this.jNDXes.size(); ++i) {
            NDXes = this.jNDXes.elementAt(i - 1);
            NDXes.check_for_duplicates(-1);
        }
        if (lock) {
            this.lock();
        }
        this.read_dbhead();
        this.seek(this.count);
        this.delete_ind = (byte)32;
        this.buffer.position(0);
        this.buffer.put(this.delete_ind);
        for (i = 0; i < this.fldcount; ++i) {
            Field tField = this.fld_root.elementAt(i);
            tField.write();
        }
        this.buffer.position(0);
        this.channel.write(this.buffer);
        int wb = 26;
        this.file.writeByte(wb);
        if (this.MDX_exist != 1 && (this.version == 3 || this.version == -125)) {
            this.buffer.position(0);
            this.channel.write(this.buffer);
            wb = 32;
            for (i = 0; i < this.lrecl; ++i) {
                this.file.writeByte(wb);
            }
        }
        for (i = 1; i <= this.jNDXes.size(); ++i) {
            NDXes = this.jNDXes.elementAt(i - 1);
            NDXes.add_entry(this.count + 1);
        }
        ++this.count;
        this.update_dbhead();
        this.current_record = this.count;
        if (lock) {
            this.unlock();
        }
        this.unlockRecord();
    }

    public void write() throws xBaseJException, IOException {
        this.write(false);
    }

    public void update(boolean lock) throws xBaseJException, IOException {
        Index NDXes;
        int i;
        if (this.current_record < 1 || this.current_record > this.count) {
            throw new xBaseJException("Invalid current record pointer");
        }
        if (lock) {
            this.lock();
        }
        this.seek(this.current_record - 1);
        this.buffer.position(1);
        for (i = 1; i <= this.jNDXes.size(); ++i) {
            NDXes = this.jNDXes.elementAt(i - 1);
            NDXes.check_for_duplicates(this.current_record);
        }
        for (i = 1; i <= this.jNDXes.size(); ++i) {
            NDXes = this.jNDXes.elementAt(i - 1);
            NDXes.find_entry(NDXes.get_active_key(), this.current_record);
        }
        for (i = 0; i < this.fldcount; ++i) {
            Field tField = this.fld_root.elementAt(i);
            if (tField instanceof MemoField) {
                tField.update();
                continue;
            }
            tField.write();
        }
        this.buffer.position(0);
        this.channel.write(this.buffer);
        for (i = 1; i <= this.jNDXes.size(); ++i) {
            NDXes = this.jNDXes.elementAt(i - 1);
            NDXes.update(this.current_record);
        }
        if (lock) {
            this.unlock();
        }
        this.unlockRecord();
    }

    public void update() throws xBaseJException, IOException {
        this.update(false);
    }

    protected void seek(long recno) throws IOException {
        long calcpos = (long)this.offset + (long)this.lrecl * recno;
        this.file.seek(calcpos);
    }

    public void delete() throws IOException, xBaseJException {
        this.lock();
        this.seek(this.current_record - 1);
        this.delete_ind = (byte)42;
        this.file.writeByte(this.delete_ind);
        this.unlock();
    }

    public void undelete() throws IOException, xBaseJException {
        this.lock();
        this.seek(this.current_record - 1);
        this.delete_ind = (byte)32;
        this.file.writeByte(this.delete_ind);
        this.unlock();
    }

    @Override
    public void close() throws IOException {
        if (this.dbtobj != null) {
            this.dbtobj.close();
        }
        if (this.jNDXes != null) {
            for (int i = 1; i <= this.jNDXes.size(); i = (int)((short)(i + 1))) {
                Index NDXes = this.jNDXes.elementAt(i - 1);
                if (!(NDXes instanceof NDX)) continue;
                NDX n = (NDX)NDXes;
                n.close();
            }
        }
        if (this.MDXfile != null) {
            this.MDXfile.close();
        }
        this.dbtobj = null;
        this.jNDXes = null;
        this.MDXfile = null;
        this.unlock();
        this.file.close();
    }

    public Field getField(int i) throws ArrayIndexOutOfBoundsException, xBaseJException {
        if (i < 1 || i > this.fldcount) {
            throw new xBaseJException("Invalid Field number");
        }
        return this.fld_root.elementAt(i - 1);
    }

    public Field getField(String name) throws xBaseJException, ArrayIndexOutOfBoundsException {
        for (short i = 0; i < this.fldcount; i = (short)(i + 1)) {
            Field tField = this.fld_root.elementAt(i);
            if (name.toUpperCase().compareTo(tField.getName().toUpperCase()) != 0) continue;
            return tField;
        }
        throw new xBaseJException("Field not found " + name);
    }

    public String getName() {
        return this.dosname;
    }

    public boolean deleted() {
        return this.delete_ind == 42;
    }

    protected void db_offset(int format, boolean memoPresent) {
        this.version = format == -11 ? (memoPresent ? (byte)-11 : (byte)4) : (format == -117 || format == 4 || this.MDX_exist == 1 ? (memoPresent ? (byte)-117 : (byte)3) : (memoPresent ? (byte)-125 : (byte)3));
        this.count = 0;
        this.offset = (short)33;
        this.lrecl = 1;
        this.incomplete_transaction = 0;
        this.encrypt_flag = 0;
        this.language = 0;
    }

    protected void read_dbhead() throws IOException {
        short currentrecord = 0;
        this.file.seek(0L);
        this.version = this.file.readByte();
        this.file.read(this.l_update, 0, 3);
        this.count = DbaseUtils.x86(this.file.readInt());
        this.offset = DbaseUtils.x86(this.file.readShort());
        this.lrecl = DbaseUtils.x86(this.file.readShort());
        currentrecord = DbaseUtils.x86(this.file.readShort());
        this.current_record = DbaseUtils.x86(currentrecord);
        this.incomplete_transaction = this.file.readByte();
        this.encrypt_flag = this.file.readByte();
        this.file.read(this.reserve, 0, 12);
        this.MDX_exist = this.file.readByte();
        this.language = this.file.readByte();
        this.file.read(this.reserve2, 0, 2);
    }

    public void update_dbhead() throws IOException {
        if (this.readonly) {
            return;
        }
        short currentrecord = 0;
        this.file.seek(0L);
        Calendar d = Calendar.getInstance();
        this.l_update[0] = d.get(1) < 2000 ? (byte)(d.get(1) - 1900) : (byte)(d.get(1) - 2000);
        this.l_update[1] = (byte)(d.get(2) + 1);
        this.l_update[2] = (byte)d.get(5);
        this.file.writeByte(this.version);
        this.file.write(this.l_update, 0, 3);
        this.file.writeInt(DbaseUtils.x86(this.count));
        this.file.writeShort(DbaseUtils.x86(this.offset));
        this.file.writeShort(DbaseUtils.x86(this.lrecl));
        this.file.writeShort(DbaseUtils.x86(currentrecord));
        this.file.write(this.incomplete_transaction);
        this.file.write(this.encrypt_flag);
        this.file.write(this.reserve, 0, 12);
        this.file.write(this.MDX_exist);
        this.file.write(this.language);
        this.file.write(this.reserve2, 0, 2);
    }

    protected Field read_Field_header() throws IOException, xBaseJException {
        Field tField;
        String name;
        int i;
        byte[] byter = new byte[15];
        this.file.readFully(byter, 0, 11);
        for (i = 0; i < 12 && byter[i] != 0; ++i) {
        }
        try {
            name = new String(byter, 0, i, encodedType);
        }
        catch (UnsupportedEncodingException UEE) {
            name = new String(byter, 0, i);
        }
        char type = (char)this.file.readByte();
        this.file.readFully(byter, 0, 4);
        int length = this.file.readByte();
        int iLength = length > 0 ? length : 256 + length;
        byte decpoint = this.file.readByte();
        this.file.readFully(byter, 0, 14);
        switch (type) {
            case 'C': {
                tField = new CharField(name, iLength, this.buffer);
                break;
            }
            case 'D': {
                tField = new DateField(name, this.buffer);
                break;
            }
            case 'F': {
                tField = new FloatField(name, iLength, decpoint, this.buffer);
                break;
            }
            case 'L': {
                tField = new LogicalField(name, this.buffer);
                break;
            }
            case 'M': {
                tField = new MemoField(name, this.buffer, this.dbtobj);
                break;
            }
            case 'N': {
                tField = new NumField(name, iLength, decpoint, this.buffer);
                break;
            }
            case 'P': {
                tField = new PictureField(name, this.buffer, this.dbtobj);
                break;
            }
            default: {
                throw new xBaseJException("Unknown Field type '" + type + "' for " + name);
            }
        }
        return tField;
    }

    protected void write_Field_header(Field tField) throws IOException, xBaseJException {
        byte[] b;
        byte[] byter = new byte[15];
        int nameLength = tField.getName().length();
        int i = 0;
        try {
            b = tField.getName().toUpperCase().getBytes(encodedType);
        }
        catch (UnsupportedEncodingException UEE) {
            b = tField.getName().toUpperCase().getBytes();
        }
        for (int x = 0; x < b.length; ++x) {
            byter[x] = b[x];
        }
        this.file.write(byter, 0, nameLength);
        for (i = 0; i < 14; ++i) {
            byter[i] = 0;
        }
        this.file.writeByte(0);
        if (nameLength < 10) {
            this.file.write(byter, 0, 10 - nameLength);
        }
        this.file.writeByte(tField.getType());
        this.file.write(byter, 0, 4);
        this.file.writeByte(tField.getLength());
        this.file.writeByte(tField.getDecimalPositionCount());
        if (this.version == 3 || this.version == -125) {
            byter[2] = 1;
        }
        this.file.write(byter, 0, 14);
    }

    public void setVersion(int b) {
        this.version = (byte)b;
    }

    public void pack() throws xBaseJException, IOException, SecurityException, CloneNotSupportedException {
        int i;
        Field[] Fields = new Field[this.fldcount];
        for (i = 1; i <= this.fldcount; ++i) {
            Fields[i - 1] = (Field)this.getField(i).clone();
        }
        String parent = this.ffile.getParent();
        if (parent == null) {
            parent = ".";
        }
        File f = File.createTempFile("tempxbase", "tmp");
        String tempname = f.getAbsolutePath();
        DBF tempDBF = new DBF(tempname, this.version, true);
        tempDBF.reserve = this.reserve;
        tempDBF.language = this.language;
        tempDBF.reserve2 = this.reserve2;
        tempDBF.MDX_exist = this.MDX_exist;
        tempDBF.addField(Fields);
        for (i = 1; i <= this.count; ++i) {
            this.gotoRecord(i);
            if (this.deleted()) continue;
            tempDBF.buffer.position(1);
            for (int j = 1; j <= this.fldcount; ++j) {
                Field t = tempDBF.getField(j);
                Field p = this.getField(j);
                t.put(p.get());
            }
            tempDBF.write();
        }
        this.file.close();
        this.ffile.delete();
        tempDBF.renameTo(this.dosname);
        if (this.dbtobj != null) {
            this.dbtobj.file.close();
            this.dbtobj.thefile.delete();
        }
        if (tempDBF.dbtobj != null) {
            tempDBF.dbtobj.rename(this.dosname);
            this.dbtobj = tempDBF.dbtobj;
            for (i = 1; i <= this.fldcount; ++i) {
                Field tField = this.getField(i);
                if (!(tField instanceof MemoField)) continue;
                MemoField mField = (MemoField)tField;
                mField.setDBTObj(this.dbtobj);
            }
        }
        this.ffile = new File(this.dosname);
        this.file = new RandomAccessFile(this.dosname, "rw");
        this.channel = this.file.getChannel();
        this.read_dbhead();
        for (i = 1; i <= this.fldcount; ++i) {
            this.getField(i).setBuffer(this.buffer);
        }
        if (this.MDXfile != null) {
            this.MDXfile.reIndex();
        }
        if (this.jNDXes.size() == 0) {
            this.current_record = 0;
        } else {
            Index NDXes;
            for (i = 1; i <= this.jNDXes.size(); ++i) {
                NDXes = this.jNDXes.elementAt(i - 1);
                NDXes.reIndex();
            }
            NDXes = this.jNDXes.elementAt(0);
            if (this.count > 0) {
                this.startTop();
            }
        }
    }

    public int getVersion() {
        return this.version;
    }

    public static void setEncodingType(String inType) {
        encodedType = inType;
    }

    public static String getEncodingType() {
        return encodedType;
    }

    public File getXML(String inFileName) throws IOException, xBaseJException {
        File file = new File(inFileName);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fos = new FileOutputStream(file);
        PrintWriter pw = new PrintWriter(fos, true);
        this.getXML(pw);
        return file;
    }

    public void getXML(PrintWriter pw) throws IOException, xBaseJException {
        Field fld;
        int i;
        pw.println("<?xml version=\"1.0\"?>");
        pw.println("<!-- org.xBaseJ release 2.1.R-->");
        pw.println("<!-- http://www.americancoders.com-->");
        pw.println("<!DOCTYPE dbf SYSTEM \"xbase.dtd\">");
        pw.println("<dbf name=\"" + DbaseUtils.normalize(this.getName()) + "\" encoding=\"" + DBF.getEncodingType() + "\">");
        for (i = 1; i <= this.getFieldCount(); ++i) {
            fld = this.getField(i);
            pw.print("  <field name=\"" + fld.getName() + "\"");
            pw.print(" type=\"" + fld.getType() + "\"");
            if (fld.getType() == 'C' || fld.getType() == 'N' || fld.getType() == 'F') {
                pw.print(" length=\"" + fld.getLength() + "\"");
            }
            if (fld.getType() == 'N' || fld.getType() == 'F') {
                pw.print(" decimalPos=\"" + fld.getDecimalPositionCount() + "\"");
            }
            pw.println("/>");
        }
        for (int j = 1; j <= this.getRecordCount(); ++j) {
            this.gotoRecord(j);
            pw.print("  <record");
            if (this.deleted()) {
                pw.print(" deleted=\"Y\"");
            }
            pw.println(">");
            for (i = 1; i <= this.getFieldCount(); ++i) {
                fld = this.getField(i);
                pw.print("    <field name=\"" + fld.getName() + "\">");
                pw.print(DbaseUtils.normalize(fld.get()));
                pw.println("</field>");
            }
            pw.println("  </record>");
        }
        pw.println("</dbf>");
        pw.close();
    }

    public void copyTo(String newname) throws IOException {
        try (FileInputStream srcInputStream = new FileInputStream(this.dosname);
             FileOutputStream targetOutputStream = new FileOutputStream(newname);
             FileChannel srcChannel = srcInputStream.getChannel();
             FileChannel dstChannel = targetOutputStream.getChannel();){
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        }
    }
}

