/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.weaving.tree;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.enumerable.lambda.weaving.ClassFilter;
import org.enumerable.lambda.weaving.ClassInjector;
import org.enumerable.lambda.weaving.Debug;
import org.enumerable.lambda.weaving.InMemoryCompiler;
import org.enumerable.lambda.weaving.asm.ClassReader;
import org.enumerable.lambda.weaving.asm.ClassWriter;
import org.enumerable.lambda.weaving.asm.Opcodes;
import org.enumerable.lambda.weaving.asm.Type;
import org.enumerable.lambda.weaving.asm.tree.ClassNode;
import org.enumerable.lambda.weaving.tree.LambdaTreeWeaver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LambdaTreeTransformer
implements Opcodes {
    Map<String, byte[]> lambdasByClassName = new HashMap<String, byte[]>();
    ClassInjector injector = new ClassInjector();

    public LambdaTreeTransformer() {
        Debug.debug("current class loader is " + this.getClass().getClassLoader());
    }

    public Map<String, byte[]> getLambdasByClassName() {
        return this.lambdasByClassName;
    }

    public byte[] transform(ClassLoader loader, ClassFilter filter, String name, InputStream in) throws Exception {
        if (this.lambdasByClassName.containsKey(name)) {
            Debug.debug("generated lambda requested by the class loader " + name);
            return this.lambdasByClassName.get(name);
        }
        ClassReader cr = new ClassReader(in);
        name = cr.getClassName();
        LambdaTreeWeaver weaver = new LambdaTreeWeaver(loader, filter, cr);
        ClassNode cn = weaver.analyze().transform();
        if (!weaver.hasLambdas()) {
            return null;
        }
        ClassWriter cw = new ClassWriter(2);
        cn.accept(cw);
        byte[] bs = cw.toByteArray();
        this.injector.dump(name, bs);
        this.injector.verifyIfAsmUtilIsAvailable(bs);
        for (LambdaTreeWeaver.MethodAnalyzer.LambdaAnalyzer la : weaver.getLambdas()) {
            cw = new ClassWriter(2);
            la.lambda.accept(cw);
            this.newLambdaClass(loader, Type.getObjectType(la.lambdaClass()).getClassName(), cw.toByteArray());
        }
        return bs;
    }

    void newLambdaClass(ClassLoader loader, String name, byte[] bs) {
        this.lambdasByClassName.put(name, bs);
        InMemoryCompiler.registerLambda(name, bs);
        this.injector.dump(name, bs);
        this.injector.verifyIfAsmUtilIsAvailable(bs);
        if (loader != null) {
            this.injector.inject(loader, name, bs);
        }
    }
}

