/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.weaving.asm.xml;

import org.enumerable.lambda.weaving.asm.AnnotationVisitor;
import org.enumerable.lambda.weaving.asm.Type;
import org.enumerable.lambda.weaving.asm.xml.SAXAdapter;
import org.enumerable.lambda.weaving.asm.xml.SAXClassAdapter;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SAXAnnotationAdapter
extends SAXAdapter
implements AnnotationVisitor {
    private final String elementName;

    public SAXAnnotationAdapter(ContentHandler contentHandler, String string, int n, String string2, String string3) {
        this(contentHandler, string, n, string3, string2, -1);
    }

    public SAXAnnotationAdapter(ContentHandler contentHandler, String string, int n, int n2, String string2) {
        this(contentHandler, string, n, string2, null, n2);
    }

    private SAXAnnotationAdapter(ContentHandler contentHandler, String string, int n, String string2, String string3, int n2) {
        super(contentHandler);
        this.elementName = string;
        AttributesImpl attributesImpl = new AttributesImpl();
        if (string3 != null) {
            attributesImpl.addAttribute("", "name", "name", "", string3);
        }
        if (n != 0) {
            attributesImpl.addAttribute("", "visible", "visible", "", n > 0 ? "true" : "false");
        }
        if (n2 != -1) {
            attributesImpl.addAttribute("", "parameter", "parameter", "", Integer.toString(n2));
        }
        if (string2 != null) {
            attributesImpl.addAttribute("", "desc", "desc", "", string2);
        }
        this.addStart(string, attributesImpl);
    }

    public void visit(String string, Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            AnnotationVisitor annotationVisitor = this.visitArray(string);
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                for (int i = 0; i < byArray.length; ++i) {
                    annotationVisitor.visit(null, new Byte(byArray[i]));
                }
            } else if (object instanceof char[]) {
                char[] cArray = (char[])object;
                for (int i = 0; i < cArray.length; ++i) {
                    annotationVisitor.visit(null, new Character(cArray[i]));
                }
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                for (int i = 0; i < sArray.length; ++i) {
                    annotationVisitor.visit(null, new Short(sArray[i]));
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                for (int i = 0; i < blArray.length; ++i) {
                    annotationVisitor.visit(null, blArray[i]);
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                for (int i = 0; i < nArray.length; ++i) {
                    annotationVisitor.visit(null, new Integer(nArray[i]));
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                for (int i = 0; i < lArray.length; ++i) {
                    annotationVisitor.visit(null, new Long(lArray[i]));
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                for (int i = 0; i < fArray.length; ++i) {
                    annotationVisitor.visit(null, new Float(fArray[i]));
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                for (int i = 0; i < dArray.length; ++i) {
                    annotationVisitor.visit(null, new Double(dArray[i]));
                }
            }
            annotationVisitor.visitEnd();
        } else {
            this.addValueElement("annotationValue", string, Type.getDescriptor(clazz), object.toString());
        }
    }

    public void visitEnum(String string, String string2, String string3) {
        this.addValueElement("annotationValueEnum", string, string2, string3);
    }

    public AnnotationVisitor visitAnnotation(String string, String string2) {
        return new SAXAnnotationAdapter(this.getContentHandler(), "annotationValueAnnotation", 0, string, string2);
    }

    public AnnotationVisitor visitArray(String string) {
        return new SAXAnnotationAdapter(this.getContentHandler(), "annotationValueArray", 0, string, null);
    }

    public void visitEnd() {
        this.addEnd(this.elementName);
    }

    private void addValueElement(String string, String string2, String string3, String string4) {
        AttributesImpl attributesImpl = new AttributesImpl();
        if (string2 != null) {
            attributesImpl.addAttribute("", "name", "name", "", string2);
        }
        if (string3 != null) {
            attributesImpl.addAttribute("", "desc", "desc", "", string3);
        }
        if (string4 != null) {
            attributesImpl.addAttribute("", "value", "value", "", SAXClassAdapter.encode(string4));
        }
        this.addElement(string, attributesImpl);
    }
}

