/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.weaving;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LambdaAgentAttach {
    public static void attachAgent() {
        LambdaAgentAttach.attachAgent(LambdaAgentAttach.agentJar());
    }

    public static void attachAgent(String pathToEnumerableJavaJar) {
        try {
            if (!LambdaAgentAttach.toolsJar().isFile()) {
                throw new IllegalStateException("Cannot find tools jar in " + System.getProperty("java.home"));
            }
            Class<?> vmClass = LambdaAgentAttach.classLoaderWithToolsJar().loadClass("com.sun.tools.attach.VirtualMachine");
            Object vm = vmClass.getMethod("attach", String.class).invoke(null, LambdaAgentAttach.pidOfRunningVM());
            vmClass.getMethod("loadAgent", String.class).invoke(vm, pathToEnumerableJavaJar);
            vmClass.getMethod("detach", new Class[0]).invoke(vm, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String agentJar() {
        Enumeration<URL> resources = LambdaAgentAttach.potentialClasspathEntries();
        while (resources.hasMoreElements()) {
            String file;
            URL url = resources.nextElement();
            if (!"jar".equals(url.getProtocol()) || !(file = url.getFile().split("!")[0]).startsWith("file:")) continue;
            return file.replace("file:", "");
        }
        throw new IllegalStateException("Cannot find Enumerable.java on classpath");
    }

    private static Enumeration<URL> potentialClasspathEntries() {
        try {
            return LambdaAgentAttach.class.getClassLoader().getResources("org/enumerable/lambda/weaving/version.properties");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static URLClassLoader classLoaderWithToolsJar() throws MalformedURLException {
        return new URLClassLoader(new URL[]{LambdaAgentAttach.toolsJar().toURI().toURL()});
    }

    private static File toolsJar() {
        return new File(System.getProperty("java.home"), "../lib/tools.jar");
    }

    private static String pidOfRunningVM() {
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        return nameOfRunningVM.substring(0, nameOfRunningVM.indexOf(64));
    }
}

