/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.weaving;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.enumerable.lambda.exception.UncheckedException;
import org.enumerable.lambda.weaving.Debug;

public class ClassInjector {
    static File classDir;
    static Method defineClass;
    static Method resolveClass;
    static Method verify;
    static Constructor<?> classReaderConstructor;

    public void inject(ClassLoader loader, String className, byte[] bs) {
        try {
            Debug.debug("defining class " + className);
            Class c = (Class)defineClass.invoke((Object)loader, className, bs, 0, bs.length);
            resolveClass.invoke((Object)loader, c);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public void dump(String name, byte[] b) {
        if (!Debug.debug) {
            return;
        }
        File file = new File(classDir, name.replace('.', '/') + ".class");
        FileOutputStream out = null;
        try {
            if (file.getParentFile().isDirectory() || file.getParentFile().mkdirs()) {
                out = new FileOutputStream(file);
                out.write(b);
            }
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException silent) {}
            }
        }
    }

    public void verifyIfAsmUtilIsAvailable(byte[] b) {
    }

    static {
        try {
            defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            defineClass.setAccessible(true);
            resolveClass = ClassLoader.class.getDeclaredMethod("resolveClass", Class.class);
            resolveClass.setAccessible(true);
            classDir = new File(System.getProperty("lambda.weaving.debug.classes.dir", "target/generated-classes/"));
            Debug.debug("writing generated classes to " + classDir.getAbsolutePath());
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
        try {
            String[] realAsmPackageNotToBeChangedByJarJar = new String[]{"org.objectweb."};
            Class<?> checkClassAdapter = Class.forName(realAsmPackageNotToBeChangedByJarJar[0] + "asm.util.CheckClassAdapter");
            Class<?> classReader = Class.forName(realAsmPackageNotToBeChangedByJarJar[0] + "asm.ClassReader");
            verify = checkClassAdapter.getMethod("verify", classReader, Boolean.TYPE, PrintWriter.class);
            classReaderConstructor = classReader.getConstructor(InputStream.class);
            Debug.debug("asm-util is avaialbe, will pre-verify generated classes");
        }
        catch (Exception ignore) {
            Debug.debug("asm-util NOT avaialbe, will not be able to pre-verify generated classes");
        }
    }
}

