/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.support.osgi;

import java.io.ByteArrayInputStream;
import java.util.Hashtable;
import org.enumerable.lambda.weaving.Debug;
import org.enumerable.lambda.weaving.LambdaLoader;
import org.enumerable.lambda.weaving.Version;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.wiring.BundleWiring;

public class LambdaWeavingActivator
implements BundleActivator,
WeavingHook {
    private LambdaLoader loader;
    private ServiceRegistration weavingHook;

    public void start(BundleContext bundleContext) throws Exception {
        Debug.debug("[osgi] " + Version.getVersionString());
        this.loader = new LambdaLoader();
        this.weavingHook = bundleContext.registerService(WeavingHook.class, (Object)this, new Hashtable());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.weavingHook != null) {
            this.weavingHook.unregister();
        }
    }

    public void weave(WovenClass wovenClass) {
        BundleWiring wiring = wovenClass.getBundleWiring();
        ByteArrayInputStream in = new ByteArrayInputStream(wovenClass.getBytes());
        byte[] newBytes = this.loader.transformClass(wiring.getClassLoader(), wovenClass.getClassName(), in);
        if (newBytes != null) {
            wovenClass.setBytes(newBytes);
        }
    }
}

