/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.enumerable.primitives;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.enumerable.lambda.enumerable.Enumerable;
import org.enumerable.lambda.enumerable.collection.EList;
import org.enumerable.lambda.enumerable.collection.ESet;
import org.enumerable.lambda.primitives.Fn1ItoB;
import org.enumerable.lambda.primitives.Fn1ItoD;
import org.enumerable.lambda.primitives.Fn1ItoI;
import org.enumerable.lambda.primitives.Fn1ItoL;
import org.enumerable.lambda.primitives.Fn1ItoO;
import org.enumerable.lambda.primitives.Fn2IItoI;
import org.enumerable.lambda.primitives.Fn2IItoO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerableInts {
    public static <E> boolean all(int[] array, Fn1ItoB block) {
        for (int each : array) {
            if (block.call(each)) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean any(int[] array, Fn1ItoB block) {
        for (int each : array) {
            if (!block.call(each)) continue;
            return true;
        }
        return false;
    }

    public static <R> Object[] collect(int[] array, Fn1ItoO<R> block) {
        Object[] result = new Object[array.length];
        int i = 0;
        for (int each : array) {
            result[i++] = block.call(each);
        }
        return result;
    }

    public static double[] collect(int[] array, Fn1ItoD block) {
        double[] result = new double[array.length];
        int i = 0;
        for (int each : array) {
            result[i++] = block.call(each);
        }
        return result;
    }

    public static int[] collect(int[] array, Fn1ItoI block) {
        int[] result = new int[array.length];
        int i = 0;
        for (int each : array) {
            result[i++] = block.call(each);
        }
        return result;
    }

    public static long[] collect(int[] array, Fn1ItoL block) {
        long[] result = new long[array.length];
        int i = 0;
        for (int each : array) {
            result[i++] = block.call(each);
        }
        return result;
    }

    public static <R> R[] collect(int[] array, Fn1ItoO<R> block, Class<R> type) {
        Object[] result = (Object[])Array.newInstance(type, array.length);
        int i = 0;
        for (int each : array) {
            result[i++] = block.call(each);
        }
        return result;
    }

    public static int detect(int[] array, int ifNone, Fn1ItoB block) {
        for (int each : array) {
            if (!block.call(each)) continue;
            return each;
        }
        return ifNone;
    }

    public static <R> int[] each(int[] array, Fn1ItoO<R> block) {
        for (int each : array) {
            block.call(each);
        }
        return array;
    }

    public static int[] each(int[] array, Fn1ItoD block) {
        for (int each : array) {
            block.call(each);
        }
        return array;
    }

    public static int[] each(int[] array, Fn1ItoI block) {
        for (int each : array) {
            block.call(each);
        }
        return array;
    }

    public static int[] each(int[] array, Fn1ItoL block) {
        for (int each : array) {
            block.call(each);
        }
        return array;
    }

    public static int[] each(int[] array, Fn1ItoB block) {
        for (int each : array) {
            block.call(each);
        }
        return array;
    }

    public static <R> int[] eachWithIndex(int[] array, Fn2IItoO<R> block) {
        int idx = 0;
        for (int each : array) {
            block.call(each, idx++);
        }
        return array;
    }

    public static int[] eachWithIndex(int[] array, Fn2IItoI block) {
        int idx = 0;
        for (int each : array) {
            block.call(each, idx++);
        }
        return array;
    }

    public static <E> EList<Integer> entries(int[] array) {
        return EnumerableInts.toList(array);
    }

    public static int find(int[] array, int ifNone, Fn1ItoB block) {
        return EnumerableInts.detect(array, ifNone, block);
    }

    public static int[] findAll(int[] array, Fn1ItoB block) {
        return EnumerableInts.select(array, block);
    }

    public static int ifNone(int defaultValue) {
        return defaultValue;
    }

    public static boolean include(int[] array, int value) {
        return EnumerableInts.member(array, value);
    }

    public static int inject(int[] array, Fn2IItoI block) {
        int initial = array[0];
        for (int i = 1; i < array.length; ++i) {
            initial = block.call(initial, array[i]);
        }
        return initial;
    }

    public static int inject(int[] array, int initial, Fn2IItoI block) {
        for (int each : array) {
            initial = block.call(initial, each);
        }
        return initial;
    }

    public static <R> Object[] map(int[] array, Fn1ItoO<R> block) {
        return EnumerableInts.collect(array, block);
    }

    public static double[] map(int[] array, Fn1ItoD block) {
        return EnumerableInts.collect(array, block);
    }

    public static int[] map(int[] array, Fn1ItoI block) {
        return EnumerableInts.collect(array, block);
    }

    public static long[] map(int[] array, Fn1ItoL block) {
        return EnumerableInts.collect(array, block);
    }

    public static <R> R[] map(int[] array, Fn1ItoO<R> block, Class<R> type) {
        return EnumerableInts.collect(array, block, type);
    }

    public static int max(int[] array) {
        return EnumerableInts.min(array, new ReverseNaturalOrderIntegerComparator(new NaturalOrderPrimitiveComparator()));
    }

    public static int max(int[] array, Fn2IItoI block) {
        return EnumerableInts.min(array, new ReverseNaturalOrderIntegerComparator(new BlockIntegerComparator(block)));
    }

    public static boolean member(int[] array, int value) {
        return Arrays.binarySearch(EnumerableInts.sort(array), value) >= 0;
    }

    public static int min(int[] array) {
        return EnumerableInts.min(array, new NaturalOrderPrimitiveComparator());
    }

    public static int min(int[] array, Fn2IItoI block) {
        return EnumerableInts.min(array, new BlockIntegerComparator(block));
    }

    public static int[][] partition(int[] array, Fn1ItoB block) {
        int[][] result = new int[][]{EnumerableInts.select(array, block), EnumerableInts.reject(array, block)};
        return result;
    }

    public static int[] reject(int[] array, Fn1ItoB block) {
        return EnumerableInts.selectOrReject(array, block, false);
    }

    public static int[] select(int[] array, Fn1ItoB block) {
        return EnumerableInts.selectOrReject(array, block, true);
    }

    private static int[] selectOrReject(int[] array, Fn1ItoB block, boolean select) {
        int[] result = new int[array.length];
        int i = 0;
        for (int each : array) {
            if (block.call(each) != select) continue;
            result[i++] = each;
        }
        return EnumerableInts.copy(result, i);
    }

    public static int[] sort(int[] array) {
        int[] result = EnumerableInts.copy(array, array.length);
        Arrays.sort(result);
        return result;
    }

    public static EList<Integer> toList(int[] array) {
        EList<Integer> result = new EList<Integer>(array.length);
        for (int each : array) {
            result.add(each);
        }
        return result;
    }

    public static ESet<Integer> toSet(int[] array) {
        return Enumerable.toSet(EnumerableInts.toList(array));
    }

    public static <R> ESet<R> toSet(int[] array, Fn1ItoO<R> block) {
        return Enumerable.toSet(EnumerableInts.toList(array), block);
    }

    static int min(int[] array, IntegerComparator comparator) {
        int result = array[0];
        for (int i = 1; i < array.length; ++i) {
            int each = array[i];
            if (comparator.compare(each, result) >= 0) continue;
            result = each;
        }
        return result;
    }

    static int[] copy(int[] array, int length) {
        int[] result = new int[length];
        System.arraycopy(array, 0, result, 0, length);
        return result;
    }

    static class ReverseNaturalOrderIntegerComparator
    implements IntegerComparator {
        IntegerComparator comparator;

        ReverseNaturalOrderIntegerComparator(IntegerComparator comparator) {
            this.comparator = comparator;
        }

        public int compare(int a, int b) {
            return -this.comparator.compare(a, b);
        }
    }

    static class BlockIntegerComparator
    implements IntegerComparator {
        Fn2IItoI block;

        BlockIntegerComparator(Fn2IItoI block) {
            this.block = block;
        }

        public int compare(int a, int b) {
            return this.block.call(a, b);
        }
    }

    static class NaturalOrderPrimitiveComparator
    implements IntegerComparator {
        NaturalOrderPrimitiveComparator() {
        }

        public int compare(double a, double b) {
            return Double.compare(a, b);
        }

        public int compare(long a, long b) {
            return a < b ? -1 : (a > b ? 1 : 0);
        }

        public int compare(int a, int b) {
            return a < b ? -1 : (a > b ? 1 : 0);
        }
    }

    static interface IntegerComparator {
        public int compare(int var1, int var2);
    }
}

