/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.enumerable.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.enumerable.lambda.Fn0;
import org.enumerable.lambda.Fn1;
import org.enumerable.lambda.Fn2;
import org.enumerable.lambda.enumerable.collection.ECollection;
import org.enumerable.lambda.enumerable.collection.EIterable;
import org.enumerable.lambda.enumerable.collection.EList;
import org.enumerable.lambda.enumerable.collection.EMap;
import org.enumerable.lambda.enumerable.collection.ESet;
import org.enumerable.lambda.enumerable.collection.IEnumerable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnumerableModule<E>
implements IEnumerable<E> {
    static final NaturalOrderComparator NATURAL_ORDER = new NaturalOrderComparator();

    public static <T, R extends EnumerableModule<T>> R extend(Iterable<T> iterable) {
        if (iterable instanceof EnumerableModule) {
            return (R)((EnumerableModule)iterable);
        }
        if (iterable instanceof List) {
            return (R)new EList((List)iterable);
        }
        if (iterable instanceof Set) {
            return (R)new ESet((Set)iterable);
        }
        if (iterable instanceof Collection) {
            return (R)new ECollection((Collection)iterable);
        }
        return (R)new EIterable<T>(iterable);
    }

    public static <K, V> EMap<K, V> extend(Map<K, V> map) {
        if (map instanceof EMap) {
            return (EMap)map;
        }
        return new EMap<K, V>(map);
    }

    @Override
    public boolean all(Fn1<? super E, ?> block) {
        for (Object each : this) {
            if (!Fn0.isFalseOrNull(block.call(each))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean all() {
        return this.all(Fn1.identity());
    }

    @Override
    public boolean any(Fn1<? super E, ?> block) {
        for (Object each : this) {
            if (!Fn0.isNotFalseOrNull(block.call(each))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean any() {
        return this.any(Fn1.identity());
    }

    @Override
    public <R> EList<R> collect(Fn1<? super E, ? extends R> block) {
        EList<R> result = new EList<R>();
        for (Object each : this) {
            result.add(block.call(each));
        }
        return result;
    }

    @Override
    public int count() {
        if (this instanceof Collection) {
            return ((Collection)((Object)this)).size();
        }
        int count = 0;
        for (Object each : this) {
            ++count;
        }
        return count;
    }

    @Override
    public int count(E obj) {
        if (obj instanceof Fn1) {
            return this.count((Fn1)obj);
        }
        int count = 0;
        if (obj == null) {
            for (Object each : this) {
                if (each != null) continue;
                ++count;
            }
        } else {
            for (Object each : this) {
                if (!obj.equals(each)) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public int count(Fn1<? super E, Boolean> block) {
        if (block == null) {
            return this.count((E)block);
        }
        return this.select(block).size();
    }

    public <R> EList<E> cycle(Fn1<? super E, R> block) {
        block0: while (true) {
            Iterator i$ = this.iterator();
            while (true) {
                if (!i$.hasNext()) continue block0;
                Object each = i$.next();
                block.call(each);
            }
            break;
        }
    }

    @Override
    public <R> EList<E> cycle(int times, Fn1<? super E, R> block) {
        if (times <= 0) {
            return null;
        }
        EList list = new EList();
        for (Object each : this) {
            block.call(each);
            list.add(each);
        }
        EList result = new EList();
        while (times-- > 0) {
            result.addAll(list);
        }
        return result;
    }

    @Override
    public E detect(Fn1<? super E, Boolean> block) {
        return this.detect(null, block);
    }

    @Override
    public E detect(Fn0<E> ifNone, Fn1<? super E, Boolean> block) {
        for (Object each : this) {
            if (!Fn0.isNotFalseOrNull(block.call(each))) continue;
            return (E)each;
        }
        return ifNone == null ? null : (E)ifNone.call();
    }

    @Override
    public EList<E> drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("attempt to drop negative size");
        }
        EList result = new EList();
        for (Object each : this) {
            if (n-- > 0) continue;
            result.add(each);
        }
        return result;
    }

    @Override
    public EList<E> dropWhile(Fn1<? super E, Boolean> block) {
        EList result = new EList();
        for (Object next : this) {
            if (result.isEmpty() && !Fn0.isFalseOrNull(block.call(next))) continue;
            result.add(next);
        }
        return result;
    }

    @Override
    public <R> EnumerableModule<E> each(Fn1<? super E, R> block) {
        for (Object each : this) {
            block.call(each);
        }
        return this;
    }

    @Override
    public <R> Object eachCons(int n, Fn1<List<E>, R> block) {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid size");
        }
        ArrayList list = new ArrayList();
        for (Object each : this) {
            list.add(each);
            if (list.size() != n) continue;
            block.call(list);
            list = new ArrayList(list.subList(1, list.size()));
        }
        return null;
    }

    @Override
    public <R> Object eachSlice(int n, Fn1<List<E>, R> block) {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid size");
        }
        ArrayList list = new ArrayList();
        for (Object each : this) {
            list.add(each);
            if (list.size() != n) continue;
            block.call(list);
            list = new ArrayList();
        }
        if (!list.isEmpty()) {
            block.call(list);
        }
        return null;
    }

    @Override
    public <R> EnumerableModule<E> eachWithIndex(Fn2<? super E, Integer, R> block) {
        int i = 0;
        for (Object each : this) {
            block.call(each, i++);
        }
        return this;
    }

    @Override
    public <M, R> M eachWithObject(M memo, Fn2<? super E, M, R> block) {
        for (Object each : this) {
            block.call(each, memo);
        }
        return memo;
    }

    @Override
    public EList<E> entries() {
        return this.toList();
    }

    @Override
    public E find(Fn1<? super E, Boolean> block) {
        return this.detect(block);
    }

    @Override
    public E find(Fn0<E> ifNone, Fn1<? super E, Boolean> block) {
        return this.detect(ifNone, block);
    }

    @Override
    public EList<E> findAll(Fn1<? super E, Boolean> block) {
        EList result = new EList();
        for (Object each : this) {
            if (!Fn0.isNotFalseOrNull(block.call(each))) continue;
            result.add(each);
        }
        return result;
    }

    @Override
    public int findIndex(Fn1<? super E, Boolean> block) {
        if (block == null) {
            return this.findIndex((E)block);
        }
        int index = 0;
        for (Object each : this) {
            if (Fn0.isNotFalseOrNull(block.call(each))) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int findIndex(final E obj) {
        if (obj instanceof Fn1) {
            return this.findIndex((E)((Fn1)obj));
        }
        return this.findIndex((E)new Fn1<E, Boolean>(){

            @Override
            public Boolean call(E a1) {
                if (obj == null) {
                    return a1 == null;
                }
                return obj.equals(a1);
            }
        });
    }

    @Override
    public E first() {
        Iterator i$ = this.iterator();
        if (i$.hasNext()) {
            Object each = i$.next();
            return (E)each;
        }
        return null;
    }

    @Override
    public EList<E> first(int n) {
        return this.take(n);
    }

    @Override
    public EList<E> grep(Pattern pattern) {
        return this.grep(pattern, Fn1.identity());
    }

    @Override
    public <R> EList<R> grep(Pattern pattern, Fn1<? super E, R> block) {
        EList<R> result = new EList<R>();
        for (Object each : this) {
            if (!pattern.matcher(each.toString()).matches()) continue;
            result.add(block.call(each));
        }
        return result;
    }

    @Override
    public EList<E> grep(String pattern) {
        return this.grep(Pattern.compile(pattern));
    }

    @Override
    public <R> EList<R> grep(String pattern, Fn1<? super E, R> block) {
        return this.grep(Pattern.compile(pattern), block);
    }

    @Override
    public <R> EMap<R, EList<E>> groupBy(Fn1<? super E, R> block) {
        EMap result = new EMap(new LinkedHashMap());
        for (Object each : this) {
            R key = block.call(each);
            if (!result.containsKey(key)) {
                result.put(key, new EList());
            }
            ((EList)result.get(key)).add(each);
        }
        return result;
    }

    @Override
    public boolean include(Object obj) {
        if (obj == null) {
            for (Object each : this) {
                if (each != null) continue;
                return true;
            }
        } else {
            for (Object each : this) {
                if (!obj.equals(each)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public E inject(Fn2<? super E, ? super E, ? extends E> block) {
        Iterator i = this.iterator();
        if (!i.hasNext()) {
            return null;
        }
        Object initial = i.next();
        while (i.hasNext()) {
            initial = block.call(initial, i.next());
        }
        return (E)initial;
    }

    @Override
    public <R> R inject(R initial, Fn2<? super R, ? super E, ? extends R> block) {
        for (Object each : this) {
            initial = block.call(initial, each);
        }
        return initial;
    }

    @Override
    public <R> EList<R> map(Fn1<? super E, ? extends R> block) {
        return this.collect(block);
    }

    @Override
    public E max() {
        Comparator reverseOrder = Collections.reverseOrder();
        return (E)this.minInternal(reverseOrder);
    }

    @Override
    public E max(final Fn2<? super E, ? super E, Integer> block) {
        return (E)this.minInternal(Collections.reverseOrder(new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return ((Number)block.call(o1, o2)).intValue();
            }
        }));
    }

    @Override
    public <R> E maxBy(Fn1<? super E, R> block) {
        return (E)this.minInternal(Collections.reverseOrder(new BlockResultComparator<E, R>(block)));
    }

    @Override
    public boolean member(Object obj) {
        return this.include(obj);
    }

    @Override
    public E min() {
        Comparator<E> naturalOrder = this.naturalOrder();
        return this.minInternal(naturalOrder);
    }

    @Override
    public E min(final Fn2<? super E, ? super E, Integer> block) {
        return this.minInternal(new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return ((Number)block.call(o1, o2)).intValue();
            }
        });
    }

    @Override
    public <R> E minBy(Fn1<? super E, R> block) {
        return this.minInternal(new BlockResultComparator<E, R>(block));
    }

    @Override
    public EList<E> minMax() {
        EList<E> result = new EList<E>();
        result.add(this.min());
        result.add(this.max());
        return result;
    }

    @Override
    public EList<E> minMax(Fn2<? super E, ? super E, Integer> block) {
        EList<E> result = new EList<E>();
        result.add(this.min(block));
        result.add(this.max(block));
        return result;
    }

    @Override
    public <R> EList<E> minMaxBy(Fn1<? super E, R> block) {
        EList<E> result = new EList<E>();
        result.add(this.minBy(block));
        result.add(this.maxBy(block));
        return result;
    }

    @Override
    public boolean none(Fn1<? super E, ?> block) {
        return !this.any(block);
    }

    @Override
    public boolean none() {
        return this.none(Fn1.identity());
    }

    @Override
    public boolean one(Fn1<? super E, ?> block) {
        Object match = null;
        for (Object each : this) {
            Object result = block.call(each);
            if (!Fn0.isNotFalseOrNull(result)) continue;
            if (match != null) {
                return false;
            }
            match = result;
        }
        return match != null;
    }

    @Override
    public boolean one() {
        return this.one(Fn1.identity());
    }

    @Override
    public EList<EList<E>> partition(Fn1<? super E, Boolean> block) {
        EList selected = new EList();
        EList rejected = new EList();
        for (Object each : this) {
            if (Fn0.isNotFalseOrNull(block.call(each))) {
                selected.add(each);
                continue;
            }
            rejected.add(each);
        }
        EList result = new EList();
        result.add(selected);
        result.add(rejected);
        return result;
    }

    @Override
    public E reduce(Fn2<? super E, ? super E, ? extends E> block) {
        return this.inject(block);
    }

    @Override
    public <R> R reduce(R initial, Fn2<? super R, ? super E, ? extends R> block) {
        return this.inject(initial, block);
    }

    @Override
    public EList<E> reject(Fn1<? super E, Boolean> block) {
        EList result = new EList();
        for (Object each : this) {
            if (!Fn0.isFalseOrNull(block.call(each))) continue;
            result.add(each);
        }
        return result;
    }

    @Override
    public <R> EnumerableModule<E> reverseEach(Fn1<? super E, R> block) {
        List<E> result = this.asNewList();
        Collections.reverse(result);
        new EList<E>(result).each(block);
        return this;
    }

    @Override
    public EList<E> select(Fn1<? super E, Boolean> block) {
        return this.findAll(block);
    }

    @Override
    public EList<E> sort() {
        return this.sortInternal(null);
    }

    @Override
    public EList<E> sort(final Fn2<? super E, ? super E, Integer> block) {
        return this.sortInternal(new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return ((Number)block.call(o1, o2)).intValue();
            }
        });
    }

    @Override
    public <R> EList<E> sortBy(Fn1<? super E, R> block) {
        return this.sortBySchwartzianTransform(block);
    }

    @Override
    public EList<E> take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("attempt to take negative size");
        }
        EList result = new EList();
        Iterator i = this.iterator();
        while (n != 0 && i.hasNext()) {
            result.add(i.next());
            --n;
        }
        return result;
    }

    @Override
    public EList<E> takeWhile(Fn1<? super E, Boolean> block) {
        EList result = new EList();
        for (Object next : this) {
            if (Fn0.isNotFalseOrNull(block.call(next))) {
                result.add(next);
                continue;
            }
            return result;
        }
        return result;
    }

    @Override
    public EList<E> toList() {
        return new EList<E>(this.asNewList());
    }

    @Override
    public ESet<E> toSet() {
        return new ESet<E>(new HashSet<E>(this.asNewList()));
    }

    @Override
    public <R> ESet<R> toSet(Fn1<? super E, R> block) {
        return new ESet<R>(new HashSet<R>(this.collect(block)));
    }

    public EList<EList<?>> zip() {
        return this.zip(new Iterable[0]);
    }

    @Override
    public <R> Object zip(List<Iterable<?>> args, Fn1<? super EList<?>, R> block) {
        this.zip(args.toArray(new Iterable[0])).each(block);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EList<EList<?>> zip(Iterable<?> ... args) {
        void var6_8;
        EList allResults = new EList();
        ArrayList iterators = new ArrayList();
        iterators.add(this.iterator());
        Iterable<?>[] arr$ = args;
        int len$ = arr$.length;
        boolean bl = false;
        while (var6_8 < len$) {
            Iterable<?> iterable = arr$[var6_8];
            iterators.add(iterable.iterator());
            ++var6_8;
        }
        while (((Iterator)iterators.get(0)).hasNext()) {
            EList result = new EList();
            for (Iterator iterator : iterators) {
                if (iterator.hasNext()) {
                    result.add(iterator.next());
                    continue;
                }
                result.add(null);
            }
            allResults.add(result);
        }
        return allResults;
    }

    List<E> asNewList() {
        if (this instanceof Collection) {
            return new ArrayList((Collection)((Object)this));
        }
        ArrayList result = new ArrayList();
        for (Object each : this) {
            result.add(each);
        }
        return result;
    }

    E minInternal(Comparator<? super E> comparator) {
        Object result = null;
        for (Object each : this) {
            if (result != null && comparator.compare(each, result) >= 0) continue;
            result = each;
        }
        return (E)result;
    }

    EList<E> sortInternal(Comparator<? super E> comparator) {
        List<E> result = this.asNewList();
        Collections.sort(result, comparator);
        return new EList<E>(result);
    }

    <R> EList<E> sortBySchwartzianTransform(Fn1<? super E, R> block) {
        EList<Pair<Object>> pairs = new EList<Pair<Object>>();
        for (Object each : this) {
            pairs.add(new Pair<R>(block.call(each), each));
        }
        Collections.sort(pairs);
        EList<Pair<Object>> result = pairs;
        for (int i = 0; i < pairs.size(); ++i) {
            result.set(i, (Pair<Object>)((Pair)pairs.get((int)i)).value);
        }
        return result;
    }

    Comparator<E> naturalOrder() {
        return NATURAL_ORDER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NaturalOrderComparator
    implements Comparator<Comparable<Object>> {
        NaturalOrderComparator() {
        }

        @Override
        public int compare(Comparable<Object> o1, Comparable<Object> o2) {
            return o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CachedBlockResultComparator<E, R>
    implements Comparator<E> {
        Map<E, R> cache = new HashMap<E, R>();
        Fn1<? super E, R> block;

        CachedBlockResultComparator(Fn1<? super E, R> block) {
            this.block = block;
        }

        R cached(E e) {
            if (!this.cache.containsKey(e)) {
                this.cache.put(e, this.block.call(e));
            }
            return this.cache.get(e);
        }

        @Override
        public int compare(E o1, E o2) {
            return ((Comparable)this.cached(o1)).compareTo(this.cached(o2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BlockResultComparator<E, R>
    implements Comparator<E> {
        Fn1<? super E, R> block;

        BlockResultComparator(Fn1<? super E, R> block) {
            this.block = block;
        }

        @Override
        public int compare(E o1, E o2) {
            return ((Comparable)this.block.call(o1)).compareTo(this.block.call(o2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Pair<R>
    implements Comparable<Pair<R>> {
        R key;
        E value;

        Pair(R key, E value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(Pair<R> o) {
            return ((Comparable)this.key).compareTo(o.key);
        }
    }
}

