/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.enumerable;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.enumerable.lambda.Fn0;
import org.enumerable.lambda.Fn1;
import org.enumerable.lambda.Fn2;
import org.enumerable.lambda.enumerable.Enumerable;
import org.enumerable.lambda.enumerable.collection.EList;
import org.enumerable.lambda.enumerable.collection.EMap;
import org.enumerable.lambda.enumerable.collection.ESet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerableArrays {
    public static <E> boolean all(E[] array, Fn1<? super E, ?> block) {
        return Enumerable.all(Arrays.asList(array), block);
    }

    public static <E> boolean all(E[] array) {
        return Enumerable.all(Arrays.asList(array));
    }

    public static <E> boolean any(E[] array, Fn1<? super E, ?> block) {
        return Enumerable.any(Arrays.asList(array), block);
    }

    public static <E> boolean any(E[] array) {
        return Enumerable.any(Arrays.asList(array));
    }

    public static <E, R> Object[] collect(E[] array, Fn1<? super E, R> block) {
        return Enumerable.collect(Arrays.asList(array), block).toArray();
    }

    public static <E, R> R[] collect(E[] array, Fn1<? super E, R> block, Class<R> type) {
        return Enumerable.collect(Arrays.asList(array), block).toArray((Object[])Array.newInstance(type, 0));
    }

    public static <E> int count(E[] array) {
        return array.length;
    }

    public static <E> int count(E[] array, E obj) {
        return Enumerable.count(Arrays.asList(array), obj);
    }

    public static <E> int count(E[] array, Fn1<? super E, Boolean> block) {
        return Enumerable.count(Arrays.asList(array), block);
    }

    public static <E, R> Object cycle(E[] array, int times, Fn1<? super E, R> block) {
        return Enumerable.cycle(Arrays.asList(array), times, block);
    }

    public static <E> E detect(E[] array, Fn1<? super E, Boolean> block) {
        return Enumerable.detect(Arrays.asList(array), block);
    }

    public static <E> E detect(E[] array, Fn0<E> ifNone, Fn1<? super E, Boolean> block) {
        return Enumerable.detect(Arrays.asList(array), ifNone, block);
    }

    public static <E, R> E[] each(E[] array, Fn1<? super E, R> block) {
        Enumerable.each(Arrays.asList(array), block);
        return array;
    }

    public static <E, R> Object eachCons(E[] array, int n, Fn1<List<E>, R> block) {
        return Enumerable.eachCons(Arrays.asList(array), n, block);
    }

    public static <E, R> Object eachSlice(E[] array, int n, Fn1<List<E>, R> block) {
        return Enumerable.eachSlice(Arrays.asList(array), n, block);
    }

    public static <E, R> E[] eachWithIndex(E[] array, Fn2<? super E, Integer, R> block) {
        Enumerable.eachWithIndex(Arrays.asList(array), block);
        return array;
    }

    public static <E> EList<E> entries(E ... array) {
        return Enumerable.toList(Arrays.asList(array));
    }

    public static <E> E find(E[] array, Fn1<? super E, Boolean> block) {
        return Enumerable.find(Arrays.asList(array), block);
    }

    public static <E> E find(E[] array, Fn0<E> ifNone, Fn1<? super E, Boolean> block) {
        return Enumerable.find(Arrays.asList(array), ifNone, block);
    }

    public static <E> E[] findAll(E[] array, Fn1<? super E, Boolean> block) {
        return Enumerable.findAll(Arrays.asList(array), block).toArray(EnumerableArrays.newEmptyArray(array));
    }

    public static <E> E[] grep(E[] array, Pattern pattern) {
        return Enumerable.grep(Arrays.asList(array), pattern).toArray(EnumerableArrays.newEmptyArray(array));
    }

    public static <E, R> Object[] grep(E[] array, Pattern pattern, Fn1<? super E, R> block) {
        return Enumerable.grep(Arrays.asList(array), pattern, block).toArray();
    }

    public static <E> E[] grep(E[] array, String pattern) {
        return Enumerable.grep(Arrays.asList(array), pattern).toArray(EnumerableArrays.newEmptyArray(array));
    }

    public static <E, R> Object[] grep(E[] array, String pattern, Fn1<? super E, R> block) {
        return Enumerable.grep(Arrays.asList(array), pattern, block).toArray();
    }

    public static <E, R> EMap<R, EList<E>> groupBy(E[] array, Fn1<? super E, R> block) {
        return Enumerable.groupBy(Arrays.asList(array), block);
    }

    public static <R> Fn0<R> ifNone(R defaultValue) {
        return Enumerable.ifNone(defaultValue);
    }

    public static <E> boolean include(E[] array, Object obj) {
        return Enumerable.include(Arrays.asList(array), obj);
    }

    public static <E> E inject(E[] array, Fn2<E, E, E> block) {
        return Enumerable.inject(Arrays.asList(array), block);
    }

    public static <E, R> R inject(E[] array, R initial, Fn2<R, E, R> block) {
        return Enumerable.inject(Arrays.asList(array), initial, block);
    }

    public static <E, R> Object[] map(E[] array, Fn1<? super E, R> block) {
        return Enumerable.map(Arrays.asList(array), block).toArray();
    }

    public static <E, R> R[] map(E[] array, Fn1<E, R> block, Class<R> type) {
        return EnumerableArrays.collect(array, block, type);
    }

    public static <E> E max(E[] array) {
        return Enumerable.max(Arrays.asList(array));
    }

    public static <E> E max(E[] array, Fn2<? super E, ? super E, Integer> block) {
        return Enumerable.max(Arrays.asList(array), block);
    }

    public static <E, R> E maxBy(E[] array, Fn1<? super E, R> block) {
        return Enumerable.maxBy(Arrays.asList(array), block);
    }

    public static <E> boolean member(E[] array, Object obj) {
        return Enumerable.member(Arrays.asList(array), obj);
    }

    public static <E> E min(E[] array) {
        return Enumerable.min(Arrays.asList(array));
    }

    public static <E> E min(E[] array, Fn2<? super E, ? super E, Integer> block) {
        return Enumerable.min(Arrays.asList(array), block);
    }

    public static <E, R> E minBy(E[] array, Fn1<? super E, R> block) {
        return Enumerable.minBy(Arrays.asList(array), block);
    }

    public static <E> E[] minMax(E[] array) {
        return Enumerable.minMax(Arrays.asList(array)).toArray(EnumerableArrays.newEmptyArray(array));
    }

    public static <E> E[] minMax(E[] array, Fn2<? super E, ? super E, Integer> block) {
        return Enumerable.minMax(Arrays.asList(array), block).toArray(EnumerableArrays.newEmptyArray(array));
    }

    public static <E, R> E[] minMaxBy(E[] array, Fn1<? super E, R> block) {
        return Enumerable.minMaxBy(Arrays.asList(array), block).toArray(EnumerableArrays.newEmptyArray(array));
    }

    public static <E> boolean none(E[] array, Fn1<? super E, ?> block) {
        return Enumerable.none(Arrays.asList(array), block);
    }

    public static <E> boolean none(E[] array) {
        return Enumerable.none(Arrays.asList(array));
    }

    public static <E> boolean one(E[] array, Fn1<? super E, ?> block) {
        return Enumerable.one(Arrays.asList(array), block);
    }

    public static <E> boolean one(E[] array) {
        return Enumerable.one(Arrays.asList(array));
    }

    public static <E> E[][] partition(E[] array, Fn1<? super E, Boolean> block) {
        EList<EList<E>> partition = Enumerable.partition(Arrays.asList(array), block);
        Object[][] result = (Object[][])Array.newInstance(array.getClass(), 2);
        result[0] = ((EList)partition.get(0)).toArray(EnumerableArrays.newEmptyArray(array));
        result[1] = ((EList)partition.get(1)).toArray(EnumerableArrays.newEmptyArray(array));
        return result;
    }

    public static Integer[] range(int start, int end) {
        return Enumerable.range(start, end).toList().toArray(new Integer[0]);
    }

    public static Integer[] range(int start, int end, boolean exclusive) {
        return Enumerable.range(start, end, exclusive).toList().toArray(new Integer[0]);
    }

    public static <E> E reduce(E[] array, Fn2<E, E, E> block) {
        return Enumerable.inject(Arrays.asList(array), block);
    }

    public static <E, R> R reduce(E[] array, R initial, Fn2<R, E, R> block) {
        return Enumerable.inject(Arrays.asList(array), initial, block);
    }

    public static <E> E[] reject(E[] array, Fn1<? super E, Boolean> block) {
        return Enumerable.reject(Arrays.asList(array), block).toArray(EnumerableArrays.newEmptyArray(array));
    }

    public static <E, R> E[] reverseEach(E[] array, Fn1<? super E, R> block) {
        Enumerable.each(new ReverseArrayIterable<E>(array), block);
        return array;
    }

    public static <E> E[] select(E[] array, Fn1<? super E, Boolean> block) {
        return Enumerable.select(Arrays.asList(array), block).toArray(EnumerableArrays.newEmptyArray(array));
    }

    public static <E> E[] sort(E[] array) {
        return Enumerable.sort(Arrays.asList(array)).toArray(EnumerableArrays.newEmptyArray(array));
    }

    public static <E> E[] sort(E[] array, Fn2<? super E, ? super E, Integer> block) {
        return Enumerable.sort(Arrays.asList(array), block).toArray(EnumerableArrays.newEmptyArray(array));
    }

    public static <E, R> E[] sortBy(E[] array, Fn1<? super E, R> block) {
        return Enumerable.sortBy(Arrays.asList(array), block).toArray(EnumerableArrays.newEmptyArray(array));
    }

    public static <E> E[] take(E[] array, int n) {
        return Enumerable.take(Arrays.asList(array), n).toArray(EnumerableArrays.newEmptyArray(array));
    }

    public static <E> E[] takeWhile(E[] array, Fn1<? super E, Boolean> block) {
        return Enumerable.takeWhile(Arrays.asList(array), block).toArray(EnumerableArrays.newEmptyArray(array));
    }

    public static <E> EList<E> toList(E ... array) {
        return Enumerable.toList(Arrays.asList(array));
    }

    public static <E> ESet<E> toSet(E ... array) {
        return Enumerable.toSet(Arrays.asList(array));
    }

    public static <E, R> ESet<R> toSet(E[] array, Fn1<? super E, R> block) {
        return Enumerable.toSet(Arrays.asList(array), block);
    }

    public static <E, R> Object zip(E[] array, Object[] args, Fn1<? super EList<?>, R> block) {
        ArrayList lists = new ArrayList();
        for (int i = 0; i < args.length; ++i) {
            lists.add(Arrays.asList(args[i]));
        }
        return Enumerable.zip(Arrays.asList(array), lists, block);
    }

    public static <E> Object[][] zip(E[] array, Object[] ... args) {
        Iterable[] lists = new Iterable[args.length];
        for (int i = 0; i < args.length; ++i) {
            lists[i] = Arrays.asList(args[i]);
        }
        EList<EList<?>> zip = Enumerable.zip(Arrays.asList(array), lists);
        Object[][] result = new Object[zip.size()][];
        for (int i = 0; i < zip.size(); ++i) {
            result[i] = ((EList)zip.get(i)).toArray();
        }
        return result;
    }

    static <T> T[] newEmptyArray(T[] array) {
        return (Object[])Array.newInstance(array.getClass().getComponentType(), 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReverseArrayIterable<T>
    implements Iterable<T> {
        T[] array;

        ReverseArrayIterable(T ... elements) {
            this.array = elements;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                int i;
                {
                    this.i = ReverseArrayIterable.this.array.length - 1;
                }

                @Override
                public boolean hasNext() {
                    return this.i >= 0;
                }

                @Override
                public T next() {
                    if (this.i < 0) {
                        throw new NoSuchElementException();
                    }
                    return ReverseArrayIterable.this.array[this.i--];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

