/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.enumerable.lambda.annotation.LambdaLocal;
import org.enumerable.lambda.exception.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Fn0<R>
implements Serializable {
    public static <R> Fn0<R> constant(final R value) {
        return new Fn0<R>(){

            @Override
            public R call() {
                return value;
            }
        };
    }

    public static boolean isNotFalseOrNull(Object obj) {
        return obj != Boolean.FALSE && obj != null;
    }

    public static boolean isFalseOrNull(Object result) {
        return !Fn0.isNotFalseOrNull(result);
    }

    public static int getAndCheckArityForMethod(Class<?> aClass, String methodName) {
        int basicArity = 0;
        for (Method method : aClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            basicArity = method.getParameterTypes().length;
        }
        TreeSet<Integer> defaultValues = new TreeSet<Integer>();
        for (Method method : aClass.getDeclaredMethods()) {
            if (!method.getName().startsWith("default$")) continue;
            defaultValues.add(Integer.valueOf(method.getName().substring("default$".length())));
        }
        boolean consecutive = true;
        if (!defaultValues.isEmpty()) {
            int lastIndex = -1;
            Iterator i$ = defaultValues.iterator();
            while (i$.hasNext()) {
                int index = (Integer)i$.next();
                if (lastIndex > 0) {
                    consecutive = index == lastIndex + 1;
                }
                lastIndex = index;
            }
            if (lastIndex != basicArity || !consecutive) {
                throw new IllegalArgumentException("parameter " + lastIndex + " cannot have a default value when there are parameters follwing without, arity is " + basicArity);
            }
            return -(basicArity - defaultValues.size() + 1);
        }
        return basicArity;
    }

    public Fn0() {
        Fn0.getAndCheckArityForMethod(this.getClass(), "call");
    }

    public abstract R call();

    public R apply(Object ... args) {
        return this.call();
    }

    public <I> I as(Class<I> anInterface) {
        return (I)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{anInterface}, (InvocationHandler)new ApplyMethodInvocationHandler(".*", new Class[0]));
    }

    public <I> I as(Class<I> anInterface, String regex, Class<?> ... parameterTypes) {
        return (I)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{anInterface}, (InvocationHandler)new ApplyMethodInvocationHandler(regex, parameterTypes));
    }

    public int arity() {
        return 0;
    }

    public Binding binding() {
        return new Binding();
    }

    public String toString() {
        return this.getClass().getName();
    }

    public Fn0<Boolean> complement() {
        return new Fn0<Boolean>(){

            @Override
            public Boolean call() {
                return 2.isFalseOrNull(Fn0.this.call());
            }
        };
    }

    public R unless(boolean test) {
        if (!test) {
            return this.call();
        }
        return null;
    }

    public <B> B whileTrue(Fn0<B> block) {
        B result = null;
        while (Fn0.isNotFalseOrNull(this.call())) {
            result = block.call();
        }
        return result;
    }

    public <B> B ifTrue(Fn0<B> block) {
        if (Fn0.isNotFalseOrNull(this.call())) {
            return block.call();
        }
        return null;
    }

    public <B> B ifFalse(Fn0<B> block) {
        if (Fn0.isFalseOrNull(this.call())) {
            return block.call();
        }
        return null;
    }

    public <B> boolean and(Fn0<B> block) {
        return Fn0.isNotFalseOrNull(this.call()) && Fn0.isNotFalseOrNull(block.call());
    }

    public <B> boolean or(Fn0<B> block) {
        return Fn0.isNotFalseOrNull(this.call()) || Fn0.isNotFalseOrNull(block.call());
    }

    public static Method getLambdaMethod(Class<?> aClass) {
        Method[] methods = aClass.getDeclaredMethods();
        if (methods.length != 1) {
            throw new IllegalArgumentException(aClass.getName() + " has more than one declared method");
        }
        return methods[0];
    }

    public Method getLambdaMethod() {
        return Fn0.getLambdaMethod(this.getClass());
    }

    public List<LambdaLocal> getParameters() {
        Annotation[][] annotations;
        Method lambdaMethod = Fn0.getLambdaMethod(this.getClass());
        ArrayList<LambdaLocal> parameters = new ArrayList<LambdaLocal>();
        for (Annotation[] annotation : annotations = lambdaMethod.getParameterAnnotations()) {
            parameters.add((LambdaLocal)annotation[0]);
        }
        return parameters;
    }

    public List<Field> getParameterFields() {
        try {
            ArrayList<Field> result = new ArrayList<Field>();
            for (LambdaLocal parameter : this.getParameters()) {
                result.add(this.getClass().getClassLoader().loadClass(parameter.parameterClass()).getField(parameter.name()));
            }
            return result;
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public class Binding {
        public Object get(String name) {
            try {
                Field field = this.findField(name);
                if (field == null) {
                    return null;
                }
                Object value = field.get(Fn0.this);
                if (!field.getAnnotation(LambdaLocal.class).isReadOnly()) {
                    value = Array.get(value, 0);
                }
                return value;
            }
            catch (Exception e) {
                throw UncheckedException.uncheck(e);
            }
        }

        public Object set(String name, Object value) {
            try {
                Field field = this.findField(name);
                if (field == null) {
                    throw new IllegalArgumentException("No such variable " + name + " in " + Fn0.this);
                }
                if (field.getAnnotation(LambdaLocal.class).isReadOnly()) {
                    throw new IllegalArgumentException("Variable " + name + " " + field.getType().getName() + " is not modifiable from " + Fn0.this);
                }
                Object array = field.get(Fn0.this);
                Object previousValue = Array.get(array, 0);
                Array.set(array, 0, value);
                return previousValue;
            }
            catch (Exception e) {
                throw UncheckedException.uncheck(e);
            }
        }

        Field findField(String name) {
            for (Field field : Fn0.this.getClass().getDeclaredFields()) {
                LambdaLocal lambdaLocal;
                if (!field.isAnnotationPresent(LambdaLocal.class) || !name.equals((lambdaLocal = field.getAnnotation(LambdaLocal.class)).name())) continue;
                field.setAccessible(true);
                return field;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ApplyMethodInvocationHandler
    implements InvocationHandler {
        Pattern pattern;
        Class<?>[] parameterTypes;

        ApplyMethodInvocationHandler(String regex, Class<?>[] parameterTypes) {
            this.parameterTypes = parameterTypes;
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!this.pattern.matcher(method.getName()).matches()) {
                return null;
            }
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                Class<?> type = this.parameterTypes[i];
                if (args[i] == null || type.isAssignableFrom(args[i].getClass())) continue;
                return null;
            }
            return Fn0.this.apply(args != null ? args : new Object[]{});
        }
    }
}

