/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.support;

import java.util.Collection;
import java.util.Comparator;
import org.rutebanken.netex.model.EntityInVersionStructure;

public class NetexVersionHelper {
    private NetexVersionHelper() {
    }

    private static int versionOf(EntityInVersionStructure e) {
        return Integer.parseInt(e.getVersion());
    }

    public static <T extends EntityInVersionStructure> T latestVersionedElementIn(Collection<T> list) {
        if (list.size() == 1) {
            return (T)((EntityInVersionStructure)list.iterator().next());
        }
        return (T)((EntityInVersionStructure)list.stream().max(NetexVersionHelper.comparingVersion()).orElse(null));
    }

    public static <T extends EntityInVersionStructure> T versionOfElementIn(Collection<T> list, String version) {
        return (T)((EntityInVersionStructure)list.stream().filter(e -> e.getVersion().equals(version)).findFirst().orElse(null));
    }

    private static <T extends EntityInVersionStructure> Comparator<T> comparingVersion() {
        return Comparator.comparingInt(NetexVersionHelper::versionOf);
    }
}

