/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.index.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.entur.netex.index.api.VersionedNetexEntityIndex;
import org.entur.netex.support.NetexVersionHelper;
import org.rutebanken.netex.model.EntityInVersionStructure;
import org.rutebanken.netex.model.EntityStructure;

public class VersionedNetexEntityIndexImpl<V extends EntityInVersionStructure>
implements VersionedNetexEntityIndex<V> {
    private final Multimap<String, V> map = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private final Map<String, V> latestMap = new ConcurrentHashMap<String, V>();

    @Override
    public V getLatestVersion(String id) {
        return (V)((EntityInVersionStructure)this.latestMap.get(id));
    }

    @Override
    public V getVersion(String id, String version) {
        return (V)NetexVersionHelper.versionOfElementIn(this.map.get((Object)id), version);
    }

    @Override
    public Collection<V> getLatestVersions() {
        return this.latestMap.values();
    }

    @Override
    public Collection<V> getAllVersions(String id) {
        return this.map.get((Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Collection<V>> getAllVersions() {
        Multimap<String, V> multimap = this.map;
        synchronized (multimap) {
            return this.map.asMap();
        }
    }

    @Override
    public void put(String id, Collection<V> entities) {
        this.map.replaceValues((Object)id, entities);
        this.latestMap.put(id, NetexVersionHelper.latestVersionedElementIn(entities));
    }

    @Override
    public void putAll(Collection<V> entities) {
        Map<String, List<EntityInVersionStructure>> entityMap = entities.stream().collect(Collectors.groupingBy(EntityStructure::getId));
        entityMap.forEach((arg_0, arg_1) -> this.map.replaceValues(arg_0, arg_1));
        this.latestMap.putAll(entityMap.keySet().stream().map(id -> NetexVersionHelper.latestVersionedElementIn(this.map.get(id))).collect(Collectors.toMap(EntityStructure::getId, e -> e)));
    }

    @Override
    public void remove(String id) {
        this.map.removeAll((Object)id);
        this.latestMap.remove(id);
    }
}

