/*
 * Decompiled with CFR 0.152.
 */
package org.rutebanken.netex.validation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class PredefinedSchemaListClasspathResourceResolver
implements LSResourceResolver {
    private Map<String, String> resourceToPathMap = new HashMap<String, String>();

    public PredefinedSchemaListClasspathResourceResolver(String schemaList) throws IOException {
        String resource;
        InputStream resourceAsStream = this.getClass().getResourceAsStream(schemaList);
        if (resourceAsStream == null) {
            throw new IOException("Unable to load " + schemaList + " as resource stream");
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(resourceAsStream));
        while ((resource = r.readLine()) != null) {
            String name = resource.substring(resource.lastIndexOf(47) + 1);
            String existing = this.resourceToPathMap.put(name, resource);
            if (existing == null) continue;
            throw new RuntimeException("Duplicate resource file on classpath " + name);
        }
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        try {
            String[] parts = systemId.split("/");
            String filename = parts[parts.length - 1];
            LSInput lsInput = this.createInput(systemId, baseURI);
            String path = this.resourceToPathMap.get(filename);
            if (path != null) {
                InputStream stream = this.getClass().getResourceAsStream(path);
                lsInput.setByteStream(stream);
            }
            return lsInput;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected LSInput createInput(final String systemId, final String baseUri) {
        return new LSInput(){
            private InputStream is;

            @Override
            public void setSystemId(String systemId2) {
            }

            @Override
            public void setStringData(String stringData) {
            }

            @Override
            public void setPublicId(String publicId) {
            }

            @Override
            public void setEncoding(String encoding) {
            }

            @Override
            public void setCharacterStream(Reader characterStream) {
            }

            @Override
            public void setCertifiedText(boolean certifiedText) {
            }

            @Override
            public void setByteStream(InputStream byteStream) {
                this.is = byteStream;
            }

            @Override
            public void setBaseURI(String baseURI) {
            }

            @Override
            public String getSystemId() {
                return systemId;
            }

            @Override
            public String getStringData() {
                return null;
            }

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getEncoding() {
                return null;
            }

            @Override
            public Reader getCharacterStream() {
                return null;
            }

            @Override
            public boolean getCertifiedText() {
                return false;
            }

            @Override
            public InputStream getByteStream() {
                return this.is;
            }

            @Override
            public String getBaseURI() {
                return baseUri;
            }
        };
    }
}

