/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.spring.test;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.entur.jwt.junit5.configuration.enrich.PropertiesFileResourceServerConfigurationEnricher;
import org.entur.jwt.junit5.extention.AuthorizationServerExtension;
import org.entur.jwt.junit5.extention.AuthorizationServerTestContext;
import org.entur.jwt.junit5.extention.AuthorizationServerTestManager;
import org.entur.jwt.junit5.impl.AuthorizationServerImplementation;
import org.entur.jwt.spring.test.JwtEnvironmentResourceServerConfiguration;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.util.Assert;

public class SpringTestResourceServerConfigurationEnricher
extends PropertiesFileResourceServerConfigurationEnricher {
    private static boolean canCheckForApplicationContext;
    private static final ExtensionContext.Namespace SPRING_EXTENTION_NAMESPACE;

    public void beforeAll(List<AuthorizationServerImplementation> authorizationServers, ExtensionContext context) throws IOException {
        TestContextManager testContextManager = SpringTestResourceServerConfigurationEnricher.getSpringTestContextManager(context);
        TestContext testContext = testContextManager.getTestContext();
        if (canCheckForApplicationContext) {
            AuthorizationServerTestManager jwtTestContextManager = SpringTestResourceServerConfigurationEnricher.getJwtTestContextManager(context);
            AuthorizationServerTestContext jwtTestContext = jwtTestContextManager.getTestContext();
            if (jwtTestContext != null) {
                JwtEnvironmentResourceServerConfiguration config;
                ApplicationContext applicationContext;
                ConfigurableEnvironment environment;
                if (testContext.hasApplicationContext() && !this.canReuse(authorizationServers, jwtTestContext, environment = (ConfigurableEnvironment)(applicationContext = testContext.getApplicationContext()).getEnvironment(), config = new JwtEnvironmentResourceServerConfiguration((Environment)environment, "entur.jwt.tenants", ".enabled"))) {
                    testContext.markApplicationContextDirty(DirtiesContext.HierarchyMode.EXHAUSTIVE);
                    testContext.setAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE, (Object)Boolean.TRUE);
                }
                super.beforeAll(authorizationServers, context);
                for (AuthorizationServerImplementation impl : authorizationServers) {
                    jwtTestContext.add(impl);
                }
            } else {
                jwtTestContextManager.setTestContext(new AuthorizationServerTestContext(authorizationServers));
                super.beforeAll(authorizationServers, context);
            }
        } else {
            super.beforeAll(authorizationServers, context);
            testContext.markApplicationContextDirty(DirtiesContext.HierarchyMode.EXHAUSTIVE);
            testContext.setAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE, (Object)Boolean.TRUE);
        }
    }

    private boolean canReuse(List<AuthorizationServerImplementation> authorizationServers, AuthorizationServerTestContext jwtTestContext, ConfigurableEnvironment environment, JwtEnvironmentResourceServerConfiguration config) {
        boolean reuse;
        Map<String, String> currentlyConfigured = config.extractEnabledProperty(environment.getPropertySources(), ".jwk.location");
        Map<String, String> desiredConfigured = this.getRequired(authorizationServers);
        if (currentlyConfigured.keySet().containsAll(desiredConfigured.keySet())) {
            reuse = true;
            block0: for (AuthorizationServerImplementation impl : authorizationServers) {
                String configured = currentlyConfigured.get(impl.getId());
                for (AuthorizationServerImplementation candidate : jwtTestContext.getAuthorizationServers(impl)) {
                    if (!configured.contains(Integer.toString(candidate.getJsonWebKeys().hashCode()))) continue;
                    impl.setEncoder(candidate.getEncoder());
                    continue block0;
                }
                reuse = false;
                break;
            }
        } else {
            reuse = false;
        }
        return reuse;
    }

    private Map<String, String> getRequired(List<AuthorizationServerImplementation> authorizationServers) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (AuthorizationServerImplementation authorizationServerImplementation : authorizationServers) {
            props.put(authorizationServerImplementation.getId(), "entur.jwt.tenants." + authorizationServerImplementation.getId() + ".jwk.location");
        }
        return props;
    }

    private static TestContextManager getSpringTestContextManager(ExtensionContext context) {
        Assert.notNull((Object)context, (String)"ExtensionContext must not be null");
        Class testClass = context.getRequiredTestClass();
        ExtensionContext.Store store = SpringTestResourceServerConfigurationEnricher.getSpringStore(context);
        return (TestContextManager)store.getOrComputeIfAbsent((Object)testClass, TestContextManager::new, TestContextManager.class);
    }

    protected static ExtensionContext.Store getSpringStore(ExtensionContext context) {
        return context.getRoot().getStore(SPRING_EXTENTION_NAMESPACE);
    }

    private static AuthorizationServerTestManager getJwtTestContextManager(ExtensionContext context) {
        ExtensionContext.Store store = AuthorizationServerExtension.getStore((ExtensionContext)context);
        return (AuthorizationServerTestManager)store.getOrComputeIfAbsent(AuthorizationServerTestManager.class);
    }

    static {
        try {
            Method method = TestContext.class.getMethod("hasApplicationContext", new Class[0]);
            canCheckForApplicationContext = method != null;
        }
        catch (Exception e) {
            canCheckForApplicationContext = false;
        }
        SPRING_EXTENTION_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{SpringExtension.class});
    }
}

