/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.spring.test;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.entur.jwt.junit5.extention.AuthorizationServerExtension;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.support.ResourcePropertySource;

@Order(value=0x7FFFFFFF)
public class JwtEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Log logger = LogFactory.getLog(JwtEnvironmentPostProcessor.class);
    public static final String PROPERTY_PREFIX = "entur.jwt.tenants.";
    public static final String PROPERTY_SOURCE_NAME = "jwtJunit5Properties";
    public static final String ON_THE_FLY_PROPERTY = ".on-the-fly";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        try {
            Path path = Paths.get("jwt.junit5.properties", new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                String mocked;
                String onTheFly;
                ResourcePropertySource source = new ResourcePropertySource("file:jwt.junit5.properties");
                Map junit5Properties = (Map)source.getSource();
                Set<String> tenants = this.extractTenants(junit5Properties);
                Set<String> configuredTentants = this.extractConfiguredTenants(environment.getPropertySources());
                if (tenants.size() == 1 && configuredTentants.size() == 1 && (onTheFly = (String)junit5Properties.get((mocked = tenants.iterator().next()) + ON_THE_FLY_PROPERTY)) != null && Boolean.parseBoolean(onTheFly)) {
                    String target = configuredTentants.iterator().next();
                    for (String string : new HashSet(junit5Properties.keySet())) {
                        if (!string.startsWith(mocked)) continue;
                        String value = (String)junit5Properties.remove(string);
                        junit5Properties.put(target + string.substring(mocked.length()), value);
                    }
                    tenants = new HashSet<String>();
                    tenants.add(target);
                }
                for (String string : new HashSet(junit5Properties.keySet())) {
                    if (!string.endsWith(ON_THE_FLY_PROPERTY)) continue;
                    junit5Properties.remove(string);
                }
                if (!tenants.containsAll(configuredTentants)) {
                    configuredTentants.removeAll(tenants);
                    logger.info((Object)("Disabling non-mocked tenants " + configuredTentants));
                    for (String tenant : configuredTentants) {
                        junit5Properties.put(tenant + ".enabled", Boolean.FALSE.toString());
                    }
                }
                for (String tenant : tenants) {
                    String property = environment.getProperty(tenant + ".issuer");
                    if (property != null) continue;
                    String mockIssuer = AuthorizationServerExtension.toDefaultIssuer((String)tenant.substring(tenant.lastIndexOf(46) + 1));
                    junit5Properties.put(tenant + ".issuer", mockIssuer);
                }
                this.addOrReplace(environment.getPropertySources(), junit5Properties);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load properties", e);
        }
    }

    private Set<String> extractTenants(Map<String, Object> junit5Properties) {
        HashSet<String> tenant = new HashSet<String>();
        for (Map.Entry<String, Object> entry : junit5Properties.entrySet()) {
            int nextDot;
            String key = entry.getKey();
            if (!key.startsWith(PROPERTY_PREFIX) || (nextDot = key.indexOf(46, PROPERTY_PREFIX.length())) == -1) continue;
            tenant.add(key.substring(0, nextDot));
        }
        return tenant;
    }

    private Set<String> extractConfiguredTenants(MutablePropertySources sources) {
        HashSet<String> tenant = new HashSet<String>();
        for (PropertySource propertySource : sources) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource epSource = (EnumerablePropertySource)propertySource;
            for (String name : epSource.getPropertyNames()) {
                if (!this.hasPropertyPrefix(name)) continue;
                tenant.add(this.parseFirstPropertyName(name));
            }
        }
        return tenant;
    }

    private String parseFirstPropertyName(String name) {
        int index = name.indexOf(46, PROPERTY_PREFIX.length());
        String result = index == -1 ? name : name.substring(0, index);
        return result;
    }

    private boolean hasPropertyPrefix(String name) {
        return name.startsWith(PROPERTY_PREFIX) && name.length() > PROPERTY_PREFIX.length();
    }

    private void addOrReplace(MutablePropertySources propertySources, Map<String, Object> map) {
        PropertySource source = propertySources.get(PROPERTY_SOURCE_NAME);
        if (source != null) {
            MapPropertySource target = (MapPropertySource)source;
            ((Map)target.getSource()).putAll(map);
        } else {
            MapPropertySource target = new MapPropertySource(PROPERTY_SOURCE_NAME, map);
            propertySources.addFirst((PropertySource)target);
        }
    }
}

