/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.validation.model;

import java.util.Map;
import org.entur.gbfs.validation.model.FileValidationResult;
import org.entur.gbfs.validation.model.ValidationResultComponentIdentity;
import org.entur.gbfs.validation.model.ValidationSummary;

public record ValidationResult(ValidationSummary summary, Map<String, FileValidationResult> files) implements ValidationResultComponentIdentity<ValidationResult>
{
    @Override
    public String toString() {
        return "ValidationResult{summary=" + this.summary + ", files=" + this.files + "}";
    }

    @Override
    public boolean sameAs(ValidationResult other) {
        if (other == null) {
            return false;
        }
        if (!this.summary.sameAs(other.summary())) {
            return false;
        }
        return this.files.entrySet().stream().allMatch(entry -> other.files.get(entry.getKey()).sameAs((FileValidationResult)entry.getValue()));
    }
}

