/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.validation.validator;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.everit.json.schema.FormatValidator;

public class URIFormatValidator
implements FormatValidator {
    public Optional<String> validate(String subject) {
        try {
            new URI(subject);
            return Optional.empty();
        }
        catch (URISyntaxException e) {
            if (e.getReason().equalsIgnoreCase("expected authority")) {
                return Optional.empty();
            }
            return Optional.of("Invalid URI");
        }
    }

    public String formatName() {
        return "uri";
    }
}

