/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.validation.validator.versions;

import org.entur.gbfs.validation.validator.versions.Version;
import org.entur.gbfs.validation.validator.versions.Version10;
import org.entur.gbfs.validation.validator.versions.Version11;
import org.entur.gbfs.validation.validator.versions.Version20;
import org.entur.gbfs.validation.validator.versions.Version21;
import org.entur.gbfs.validation.validator.versions.Version22;
import org.entur.gbfs.validation.validator.versions.Version23;
import org.entur.gbfs.validation.validator.versions.Version30;

public class VersionFactory {
    private VersionFactory() {
    }

    public static Version createVersion(String version) {
        switch (version) {
            case "1.0": {
                return new Version10();
            }
            case "1.1": {
                return new Version11();
            }
            case "2.0": {
                return new Version20();
            }
            case "2.1": {
                return new Version21();
            }
            case "2.2": {
                return new Version22();
            }
            case "2.3": {
                return new Version23();
            }
            case "3.0": {
                return new Version30();
            }
        }
        throw new UnsupportedOperationException("Version not implemented");
    }
}

