/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.validation.validator.rules;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.util.Map;
import org.entur.gbfs.validation.validator.rules.CustomRuleSchemaPatcher;
import org.json.JSONArray;
import org.json.JSONObject;

public class NoMissingVehicleTypeIdInVehicleStatusWhenVehicleTypesExist
implements CustomRuleSchemaPatcher {
    private final String fileName;
    public static final String BIKE_ITEMS_REQUIRED = "$.properties.data.properties.bikes.items.required";
    public static final String VEHICLE_ITEMS_REQUIRED = "$.properties.data.properties.vehicles.items.required";

    public NoMissingVehicleTypeIdInVehicleStatusWhenVehicleTypesExist(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public DocumentContext addRule(DocumentContext rawSchemaDocumentContext, Map<String, JSONObject> feeds) {
        JSONObject vehicleTypesFeed = feeds.get("vehicle_types");
        String requiredPath = VEHICLE_ITEMS_REQUIRED;
        if (this.fileName.equals("free_bike_status")) {
            requiredPath = BIKE_ITEMS_REQUIRED;
        }
        JSONArray vehicleItemsRequiredSchema = (JSONArray)rawSchemaDocumentContext.read(requiredPath, new Predicate[0]);
        if (vehicleTypesFeed != null) {
            vehicleItemsRequiredSchema.put((Object)"vehicle_type_id");
        }
        return rawSchemaDocumentContext.set(requiredPath, (Object)vehicleItemsRequiredSchema, new Predicate[0]);
    }
}

