/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.validation.validator.rules;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Map;
import org.entur.gbfs.validation.validator.rules.CustomRuleSchemaPatcher;
import org.json.JSONArray;
import org.json.JSONObject;

public class NoMissingStoreUriInSystemInformation
implements CustomRuleSchemaPatcher {
    private static final String DATA_REQUIRED_SCHEMA_PATH = "$.properties.data.required";
    private static final String RENTAL_APPS_SCHEMA_PATH = "$.properties.data.properties.rental_apps";
    private final String vehicleStatusFileName;

    public NoMissingStoreUriInSystemInformation(String vehicleStatusFileName) {
        this.vehicleStatusFileName = vehicleStatusFileName;
    }

    @Override
    public DocumentContext addRule(DocumentContext rawSchemaDocumentContext, Map<String, JSONObject> feeds) {
        JSONObject stationInformationFeed;
        boolean hasIosRentalUris = false;
        boolean hasAndroidRentalUris = false;
        JSONObject vehicleStatusFeed = feeds.get(this.vehicleStatusFileName);
        if (vehicleStatusFeed != null) {
            String vehiclesKey;
            String string = vehiclesKey = this.vehicleStatusFileName.equals("vehicle_status") ? "vehicles" : "bikes";
            if (!((JSONArray)JsonPath.parse((Object)vehicleStatusFeed).read("$.data." + vehiclesKey + "[:1].rental_uris.ios", new Predicate[0])).isEmpty()) {
                hasIosRentalUris = true;
            }
            if (!((JSONArray)JsonPath.parse((Object)vehicleStatusFeed).read("$.data." + vehiclesKey + "[:1].rental_uris.android", new Predicate[0])).isEmpty()) {
                hasAndroidRentalUris = true;
            }
        }
        if ((stationInformationFeed = feeds.get("station_information")) != null) {
            if (!((JSONArray)JsonPath.parse((Object)stationInformationFeed).read("$.data.stations[:1].rental_uris.ios", new Predicate[0])).isEmpty()) {
                hasIosRentalUris = true;
            }
            if (!((JSONArray)JsonPath.parse((Object)stationInformationFeed).read("$.data.stations[:1].rental_uris.android", new Predicate[0])).isEmpty()) {
                hasAndroidRentalUris = true;
            }
        }
        if (hasIosRentalUris || hasAndroidRentalUris) {
            JSONArray systemInformationDataRequiredSchema = (JSONArray)rawSchemaDocumentContext.read(DATA_REQUIRED_SCHEMA_PATH, new Predicate[0]);
            systemInformationDataRequiredSchema.put((Object)"rental_apps");
            JSONObject rentalAppsSchema = (JSONObject)rawSchemaDocumentContext.read(RENTAL_APPS_SCHEMA_PATH, new Predicate[0]);
            JSONArray rentalAppRequired = new JSONArray();
            if (hasIosRentalUris) {
                rentalAppRequired.put((Object)"ios");
            }
            if (hasAndroidRentalUris) {
                rentalAppRequired.put((Object)"android");
            }
            rentalAppsSchema.put("required", (Object)rentalAppRequired);
        }
        return rawSchemaDocumentContext;
    }
}

