/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.validation.model;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.entur.gbfs.validation.model.FileValidationError;
import org.entur.gbfs.validation.model.ValidationResultComponentIdentity;

public class FileValidationResult
implements ValidationResultComponentIdentity<FileValidationResult> {
    private String file;
    private boolean required;
    private boolean exists;
    private int errorsCount;
    private String schema;
    private String fileContents;
    private String version;
    private List<FileValidationError> errors = Collections.emptyList();

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public int getErrorsCount() {
        return this.errorsCount;
    }

    public void setErrorsCount(int errorsCount) {
        this.errorsCount = errorsCount;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getFileContents() {
        return this.fileContents;
    }

    public void setFileContents(String fileContents) {
        this.fileContents = fileContents;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<FileValidationError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<FileValidationError> errors) {
        this.errors = errors;
    }

    public String toString() {
        return "FileValidationResult{file='" + this.file + "', required=" + this.required + ", exists=" + this.exists + ", errorsCount=" + this.errorsCount + ", schema='" + this.schema + "', fileContents='" + this.fileContents + "', version='" + this.version + "', errors=" + this.errors + "}";
    }

    @Override
    public boolean sameAs(FileValidationResult other) {
        if (other == null) {
            return false;
        }
        if (this.required != other.required) {
            return false;
        }
        if (this.exists != other.exists) {
            return false;
        }
        if (this.errorsCount != other.errorsCount) {
            return false;
        }
        if (!Objects.equals(this.file, other.file)) {
            return false;
        }
        if (!Objects.equals(this.version, other.version)) {
            return false;
        }
        return IntStream.range(0, this.errors.size()).allMatch(i -> this.errors.get(i).sameAs(other.errors.get(i)));
    }
}

