/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.loader;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.entur.gbfs.authentication.DummyRequestAuthenticator;
import org.entur.gbfs.authentication.RequestAuthenticator;
import org.entur.gbfs.http.GBFSFeedUpdater;
import org.entur.gbfs.loader.DuplicateFeedException;
import org.entur.gbfs.loader.GbfsFeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGbfsLoader<S, T> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseGbfsLoader.class);
    private final AtomicBoolean setupComplete = new AtomicBoolean(false);
    private final Lock updateLock = new ReentrantLock();
    private final Map<S, GBFSFeedUpdater<?>> feedUpdaters = new HashMap();
    private final Map<Class<?>, S> classMap = new HashMap();
    private T disoveryFileData;
    private final GBFSFeedUpdater<T> discoveryFileUpdater;
    private final Map<String, String> httpHeaders;
    private final RequestAuthenticator requestAuthenticator;
    private final Long timeoutConnection;

    protected BaseGbfsLoader(String discoveryUrl, Map<String, String> httpHeaders, RequestAuthenticator requestAuthenticator, Long timeoutConnection, Class<T> discoveryFileClass) {
        this.requestAuthenticator = Objects.requireNonNullElseGet(requestAuthenticator, DummyRequestAuthenticator::new);
        this.httpHeaders = httpHeaders;
        this.timeoutConnection = timeoutConnection;
        this.discoveryFileUpdater = new GBFSFeedUpdater<T>(URI.create(discoveryUrl), this.requestAuthenticator, discoveryFileClass, httpHeaders, timeoutConnection);
    }

    public synchronized void init() {
        if (this.setupComplete.get()) {
            return;
        }
        try {
            if (this.discoveryFileUpdater.fetchOnce()) {
                this.disoveryFileData = this.discoveryFileUpdater.getData();
                this.createUpdaters();
                this.setupComplete.set(true);
            } else {
                LOG.warn("Could not fetch the feed auto-configuration file from {}", (Object)this.discoveryFileUpdater.getUrl());
            }
        }
        catch (RuntimeException e) {
            LOG.warn("Caught exception while creating updaters - message={}", (Object)e.getMessage());
        }
    }

    public boolean getSetupComplete() {
        return this.setupComplete.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update() {
        if (!this.setupComplete.get()) {
            this.init();
        }
        boolean didUpdate = false;
        if (this.updateLock.tryLock()) {
            try {
                for (GBFSFeedUpdater<?> updater : this.feedUpdaters.values()) {
                    if (!updater.update()) continue;
                    didUpdate = true;
                }
            }
            finally {
                this.updateLock.unlock();
            }
        }
        return didUpdate;
    }

    private void createUpdaters() {
        for (GbfsFeed<S, ?> feed : this.getFeeds()) {
            S feedName = feed.name();
            if (this.feedUpdaters.containsKey(feedName)) {
                throw new DuplicateFeedException("Feed contains duplicate url for feed " + feedName + ". Urls: " + feed.uri() + ", " + this.feedUpdaters.get(feedName).getUrl());
            }
            if (feedName == null) continue;
            this.feedUpdaters.put(feedName, new GBFSFeedUpdater(feed.uri(), this.requestAuthenticator, feed.implementingClass(), this.httpHeaders, this.timeoutConnection));
            this.classMap.put(feed.implementingClass(), feedName);
        }
    }

    protected abstract List<GbfsFeed<S, ?>> getFeeds();

    public T getDiscoveryFeed() {
        return this.disoveryFileData;
    }

    public <R> R getFeed(Class<R> feed) {
        GBFSFeedUpdater<?> updater = this.feedUpdaters.get(this.classMap.get(feed));
        if (updater == null) {
            return null;
        }
        return feed.cast(updater.getData());
    }

    public Optional<byte[]> getRawFeed(S feedName) {
        if (feedName == this.getDiscoveryFeedName()) {
            return this.discoveryFileUpdater.getRawData();
        }
        GBFSFeedUpdater<?> updater = this.feedUpdaters.get(feedName);
        if (updater == null) {
            return Optional.empty();
        }
        return updater.getRawData();
    }

    protected abstract S getDiscoveryFeedName();
}

