/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.loader.v2;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import org.entur.gbfs.GbfsSubscriptionOptions;
import org.entur.gbfs.SubscriptionUpdateInterceptor;
import org.entur.gbfs.loader.GbfsSubscription;
import org.entur.gbfs.loader.v2.GbfsV2Delivery;
import org.entur.gbfs.loader.v2.GbfsV2Loader;
import org.entur.gbfs.validation.GbfsValidator;
import org.entur.gbfs.validation.GbfsValidatorFactory;
import org.entur.gbfs.validation.model.ValidationResult;
import org.mobilitydata.gbfs.v2_3.free_bike_status.GBFSFreeBikeStatus;
import org.mobilitydata.gbfs.v2_3.gbfs.GBFS;
import org.mobilitydata.gbfs.v2_3.gbfs.GBFSFeedName;
import org.mobilitydata.gbfs.v2_3.gbfs_versions.GBFSGbfsVersions;
import org.mobilitydata.gbfs.v2_3.geofencing_zones.GBFSGeofencingZones;
import org.mobilitydata.gbfs.v2_3.station_information.GBFSStationInformation;
import org.mobilitydata.gbfs.v2_3.station_status.GBFSStationStatus;
import org.mobilitydata.gbfs.v2_3.system_alerts.GBFSSystemAlerts;
import org.mobilitydata.gbfs.v2_3.system_calendar.GBFSSystemCalendar;
import org.mobilitydata.gbfs.v2_3.system_hours.GBFSSystemHours;
import org.mobilitydata.gbfs.v2_3.system_information.GBFSSystemInformation;
import org.mobilitydata.gbfs.v2_3.system_pricing_plans.GBFSSystemPricingPlans;
import org.mobilitydata.gbfs.v2_3.system_regions.GBFSSystemRegions;
import org.mobilitydata.gbfs.v2_3.vehicle_types.GBFSVehicleTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GbfsV2Subscription
implements GbfsSubscription {
    private static final Logger LOG = LoggerFactory.getLogger(GbfsV2Subscription.class);
    private final GbfsSubscriptionOptions subscriptionOptions;
    private final Consumer<GbfsV2Delivery> consumer;
    private final SubscriptionUpdateInterceptor updateInterceptor;
    private GbfsV2Loader loader;

    public GbfsV2Subscription(GbfsSubscriptionOptions subscriptionOptions, Consumer<GbfsV2Delivery> consumer) {
        this.subscriptionOptions = subscriptionOptions;
        this.consumer = consumer;
        this.updateInterceptor = null;
    }

    public GbfsV2Subscription(GbfsSubscriptionOptions subscriptionOptions, Consumer<GbfsV2Delivery> consumer, SubscriptionUpdateInterceptor updateInterceptor) {
        this.subscriptionOptions = subscriptionOptions;
        this.consumer = consumer;
        this.updateInterceptor = updateInterceptor;
    }

    @Override
    public void init() {
        this.loader = new GbfsV2Loader(this.subscriptionOptions.discoveryURI().toString(), this.subscriptionOptions.headers(), this.subscriptionOptions.languageCode(), this.subscriptionOptions.requestAuthenticator(), this.subscriptionOptions.timeout());
    }

    @Override
    public boolean getSetupComplete() {
        return this.loader.getSetupComplete();
    }

    @Override
    public void update() {
        if (this.updateInterceptor != null) {
            this.updateInterceptor.beforeUpdate();
        }
        try {
            if (this.loader.update()) {
                GbfsV2Delivery delivery = new GbfsV2Delivery((GBFS)this.loader.getDiscoveryFeed(), this.loader.getFeed(GBFSGbfsVersions.class), this.loader.getFeed(GBFSSystemInformation.class), this.loader.getFeed(GBFSVehicleTypes.class), this.loader.getFeed(GBFSStationInformation.class), this.loader.getFeed(GBFSStationStatus.class), this.loader.getFeed(GBFSFreeBikeStatus.class), this.loader.getFeed(GBFSSystemHours.class), this.loader.getFeed(GBFSSystemCalendar.class), this.loader.getFeed(GBFSSystemRegions.class), this.loader.getFeed(GBFSSystemPricingPlans.class), this.loader.getFeed(GBFSSystemAlerts.class), this.loader.getFeed(GBFSGeofencingZones.class), Boolean.TRUE.equals(this.subscriptionOptions.enableValidation()) ? this.validateFeeds() : null);
                this.consumer.accept(delivery);
            }
        }
        catch (RuntimeException e) {
            LOG.error("Exception occurred during update", (Throwable)e);
            throw e;
        }
        finally {
            if (this.updateInterceptor != null) {
                this.updateInterceptor.afterUpdate();
            }
        }
    }

    private ValidationResult validateFeeds() {
        HashMap feeds = new HashMap();
        Arrays.stream(GBFSFeedName.values()).forEach(feedName -> this.loader.getRawFeed(feedName).ifPresent(rawFeed -> feeds.put(feedName.value(), new ByteArrayInputStream((byte[])rawFeed))));
        GbfsValidator validator = GbfsValidatorFactory.getGbfsJsonValidator();
        return validator.validate(feeds);
    }
}

