/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.http;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.entur.gbfs.authentication.RequestAuthenticator;
import org.entur.gbfs.http.GBFSHttpClient;
import org.entur.gbfs.http.UpdateStrategy;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GBFSFeedUpdater<T> {
    private static final Logger LOG = LoggerFactory.getLogger(GBFSFeedUpdater.class);
    public static final String GET_LAST_UPDATED = "getLastUpdated";
    private final URI url;
    private final Class<T> implementingClass;
    private final RequestAuthenticator requestAuthenticator;
    private T data;
    private byte[] rawData = null;
    private final UpdateStrategy updateStrategy;
    private final GBFSHttpClient httpClient;
    private Map<String, String> httpHeaders = new HashMap<String, String>();
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final Long timeout;

    public GBFSFeedUpdater(@NotNull URI url, @NotNull RequestAuthenticator requestAuthenticator, @NotNull Class<T> implementingClass, Map<String, String> httpHeaders, Long timeout) {
        this(url, requestAuthenticator, implementingClass, httpHeaders, timeout, new GBFSHttpClient(), new UpdateStrategy());
    }

    protected GBFSFeedUpdater(@NotNull URI url, @NotNull RequestAuthenticator requestAuthenticator, @NotNull Class<T> implementingClass, Map<String, String> httpHeaders, Long timeout, @NotNull GBFSHttpClient httpClient, @NotNull UpdateStrategy updateStrategy) {
        this.url = url;
        this.requestAuthenticator = requestAuthenticator;
        this.implementingClass = implementingClass;
        if (httpHeaders != null) {
            this.httpHeaders = httpHeaders;
        }
        this.timeout = timeout;
        this.httpClient = httpClient;
        this.updateStrategy = updateStrategy;
    }

    public URI getUrl() {
        return this.url;
    }

    public T getData() {
        return this.data;
    }

    public Optional<byte[]> getRawData() {
        return Optional.ofNullable(this.rawData);
    }

    public boolean fetchOnce() {
        this.requestAuthenticator.authenticateRequest(this.httpHeaders);
        this.rawData = this.fetchFeed(this.url, this.httpHeaders).orElse(null);
        if (!this.validateRawData(this.rawData)) {
            return false;
        }
        return this.deserializeData(this.rawData);
    }

    public boolean update() {
        if (!this.shouldUpdate()) {
            return false;
        }
        this.requestAuthenticator.authenticateRequest(this.httpHeaders);
        byte[] fetchedData = this.fetchFeed(this.url, this.httpHeaders).orElse(null);
        if (fetchedData == null && this.updateStrategy.getFailedAttemptsCount() < 3) {
            this.updateStrategy.rescheduleAfterFailure();
            return false;
        }
        this.rawData = fetchedData;
        if (!this.validateRawData(this.rawData)) {
            this.updateStrategy.rescheduleAfterFailure();
            return false;
        }
        if (!this.deserializeData(this.rawData)) {
            this.updateStrategy.rescheduleAfterFailure();
            return false;
        }
        if (!this.scheduleNextUpdate()) {
            this.updateStrategy.rescheduleAfterFailure();
            return false;
        }
        return true;
    }

    private boolean shouldUpdate() {
        return this.updateStrategy.shouldUpdate();
    }

    private Optional<byte[]> fetchFeed(URI uri, Map<String, String> httpHeaders) {
        String proto = uri.getScheme();
        if (proto.equals("http") || proto.equals("https")) {
            return this.fetchFeedFromHttp(uri, httpHeaders);
        }
        return this.fetchFeedFromFile(uri);
    }

    private Optional<byte[]> fetchFeedFromFile(URI uri) {
        Optional<byte[]> optional;
        block9: {
            InputStream is = uri.toURL().openStream();
            try {
                optional = Optional.of(is.readAllBytes());
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedURLException e) {
                    LOG.warn("Error reading GBFS feed from file due to malformed URL {}", (Object)uri, (Object)e);
                    return Optional.empty();
                }
                catch (IOException e) {
                    LOG.warn("Error reading GBFS feed from file {}", (Object)uri, (Object)e);
                    return Optional.empty();
                }
            }
            is.close();
        }
        return optional;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<byte[]> fetchFeedFromHttp(URI uri, Map<String, String> httpHeaders) {
        try (InputStream is = this.httpClient.getData(uri, this.timeout, httpHeaders);){
            if (is == null) {
                LOG.warn("Failed to get data from url {}", (Object)uri);
                Optional<byte[]> optional2 = Optional.empty();
                return optional2;
            }
            Optional<byte[]> optional = Optional.of(is.readAllBytes());
            return optional;
        }
        catch (IOException e) {
            LOG.warn("Error (bad connection) reading GBFS feed from {}", (Object)uri, (Object)e);
            return Optional.empty();
        }
    }

    private boolean validateRawData(byte[] rawData) {
        if (rawData == null) {
            LOG.warn("Invalid data for {}", (Object)this.url);
            this.data = null;
            return false;
        }
        return true;
    }

    private boolean deserializeData(byte[] rawData) {
        try {
            this.data = objectMapper.readValue(rawData, this.implementingClass);
        }
        catch (IOException e) {
            LOG.warn("Error unmarshalling feed", (Throwable)e);
            this.data = null;
        }
        return this.data != null;
    }

    private boolean scheduleNextUpdate() {
        try {
            Integer lastUpdated;
            if (this.implementingClass.getMethod(GET_LAST_UPDATED, new Class[0]).getReturnType().equals(Integer.class)) {
                lastUpdated = (Integer)this.implementingClass.getMethod(GET_LAST_UPDATED, new Class[0]).invoke(this.data, new Object[0]);
            } else {
                Date lastUpdatedDate = (Date)this.implementingClass.getMethod(GET_LAST_UPDATED, new Class[0]).invoke(this.data, new Object[0]);
                lastUpdated = Math.toIntExact(lastUpdatedDate.getTime() / 1000L);
            }
            Integer ttl = (Integer)this.implementingClass.getMethod("getTtl", new Class[0]).invoke(this.data, new Object[0]);
            this.updateStrategy.scheduleNextUpdate(lastUpdated, ttl);
            return true;
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
            LOG.warn("Invalid data for {}", (Object)this.url);
            return false;
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
    }
}

