/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.http;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateStrategy.class);
    private static int maxBackoffSeconds = 3600;
    private int failedAttemptsCount = 0;
    private int nextUpdate;

    public boolean shouldUpdate() {
        return this.getCurrentTimeSeconds() >= this.nextUpdate;
    }

    public void rescheduleAfterFailure() {
        ++this.failedAttemptsCount;
        int backoffSeconds = Math.min(maxBackoffSeconds, (int)Math.pow(2.0, (double)this.failedAttemptsCount - 1.0));
        int randomOffset = (int)(Math.random() * 0.05 * (double)backoffSeconds);
        this.nextUpdate = this.getCurrentTimeSeconds() + backoffSeconds - randomOffset;
        LOG.info("Rescheduled nextUpdate after {} failure(s) to {}", (Object)this.failedAttemptsCount, (Object)this.nextUpdate);
    }

    private int getCurrentTimeSeconds() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public void scheduleNextUpdate(Integer lastUpdated, Integer ttl) {
        this.failedAttemptsCount = 0;
        this.nextUpdate = lastUpdated == null || ttl == null ? this.getCurrentTimeSeconds() : lastUpdated + ttl;
    }

    public int getFailedAttemptsCount() {
        return this.failedAttemptsCount;
    }
}

