/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GBFSHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(GBFSHttpClient.class);
    private static final long TIMEOUT_CONNECTION = 5000L;

    public InputStream getData(URI uri) throws IOException {
        return this.getData(uri, null);
    }

    public InputStream getData(String uri) throws IOException {
        return this.getData(URI.create(uri));
    }

    public InputStream getData(URI uri, Long timeout, Map<String, String> requestHeaderValues) throws IOException {
        HttpClient httpclient;
        HttpResponse response;
        HttpGet httpget = new HttpGet(uri);
        if (requestHeaderValues != null) {
            for (Map.Entry<String, String> entry : requestHeaderValues.entrySet()) {
                httpget.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if ((response = (httpclient = this.getClient(timeout = Long.valueOf(timeout == null ? 5000L : timeout))).execute((HttpUriRequest)httpget)).getStatusLine().getStatusCode() != 200) {
            LOG.warn("Got non-200 status code: {}", (Object)response.getStatusLine().getStatusCode());
            return null;
        }
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        return entity.getContent();
    }

    public InputStream getData(URI uri, Map<String, String> requestHeaderValues) throws IOException {
        return this.getData(uri, 5000L, requestHeaderValues);
    }

    private HttpClient getClient(long timeoutSocket) {
        return HttpClientBuilder.create().setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(null)).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout((int)timeoutSocket).build()).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).build();
    }
}

