/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.loader.v3;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import org.entur.gbfs.GbfsSubscriptionOptions;
import org.entur.gbfs.SubscriptionUpdateInterceptor;
import org.entur.gbfs.loader.GbfsSubscription;
import org.entur.gbfs.loader.v3.GbfsV3Delivery;
import org.entur.gbfs.loader.v3.GbfsV3Loader;
import org.entur.gbfs.validation.GbfsValidator;
import org.entur.gbfs.validation.GbfsValidatorFactory;
import org.entur.gbfs.validation.model.ValidationResult;
import org.mobilitydata.gbfs.v3_0.gbfs.GBFSFeed;
import org.mobilitydata.gbfs.v3_0.gbfs.GBFSGbfs;
import org.mobilitydata.gbfs.v3_0.gbfs_versions.GBFSGbfsVersions;
import org.mobilitydata.gbfs.v3_0.geofencing_zones.GBFSGeofencingZones;
import org.mobilitydata.gbfs.v3_0.station_information.GBFSStationInformation;
import org.mobilitydata.gbfs.v3_0.station_status.GBFSStationStatus;
import org.mobilitydata.gbfs.v3_0.system_alerts.GBFSSystemAlerts;
import org.mobilitydata.gbfs.v3_0.system_information.GBFSSystemInformation;
import org.mobilitydata.gbfs.v3_0.system_pricing_plans.GBFSSystemPricingPlans;
import org.mobilitydata.gbfs.v3_0.system_regions.GBFSSystemRegions;
import org.mobilitydata.gbfs.v3_0.vehicle_status.GBFSVehicleStatus;
import org.mobilitydata.gbfs.v3_0.vehicle_types.GBFSVehicleTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GbfsV3Subscription
implements GbfsSubscription {
    private static final Logger LOG = LoggerFactory.getLogger(GbfsV3Subscription.class);
    private final GbfsSubscriptionOptions subscriptionOptions;
    private final Consumer<GbfsV3Delivery> consumer;
    private final SubscriptionUpdateInterceptor updateInterceptor;
    private GbfsV3Loader loader;

    public GbfsV3Subscription(GbfsSubscriptionOptions subscriptionOptions, Consumer<GbfsV3Delivery> consumer) {
        this.subscriptionOptions = subscriptionOptions;
        this.consumer = consumer;
        this.updateInterceptor = null;
    }

    public GbfsV3Subscription(GbfsSubscriptionOptions subscriptionOptions, Consumer<GbfsV3Delivery> consumer, SubscriptionUpdateInterceptor updateInterceptor) {
        this.subscriptionOptions = subscriptionOptions;
        this.consumer = consumer;
        this.updateInterceptor = updateInterceptor;
    }

    @Override
    public void init() {
        this.loader = new GbfsV3Loader(this.subscriptionOptions.discoveryURI().toString(), this.subscriptionOptions.headers(), this.subscriptionOptions.requestAuthenticator(), this.subscriptionOptions.timeout());
    }

    @Override
    public boolean getSetupComplete() {
        return this.loader.getSetupComplete();
    }

    @Override
    public void update() {
        if (this.updateInterceptor != null) {
            this.updateInterceptor.beforeUpdate();
        }
        try {
            if (this.loader.update()) {
                GbfsV3Delivery delivery = new GbfsV3Delivery((GBFSGbfs)this.loader.getDiscoveryFeed(), this.loader.getFeed(GBFSGbfsVersions.class), this.loader.getFeed(GBFSSystemInformation.class), this.loader.getFeed(GBFSVehicleTypes.class), this.loader.getFeed(GBFSStationInformation.class), this.loader.getFeed(GBFSStationStatus.class), this.loader.getFeed(GBFSVehicleStatus.class), this.loader.getFeed(GBFSSystemRegions.class), this.loader.getFeed(GBFSSystemPricingPlans.class), this.loader.getFeed(GBFSSystemAlerts.class), this.loader.getFeed(GBFSGeofencingZones.class), Boolean.TRUE.equals(this.subscriptionOptions.enableValidation()) ? this.validateFeeds() : null);
                this.consumer.accept(delivery);
            }
        }
        catch (RuntimeException e) {
            LOG.error("Exception occurred during update", (Throwable)e);
            throw e;
        }
        finally {
            if (this.updateInterceptor != null) {
                this.updateInterceptor.afterUpdate();
            }
        }
    }

    private ValidationResult validateFeeds() {
        HashMap feeds = new HashMap();
        Arrays.stream(GBFSFeed.Name.values()).forEach(feedName -> this.loader.getRawFeed(feedName).ifPresent(rawFeed -> feeds.put(feedName.value(), new ByteArrayInputStream((byte[])rawFeed))));
        GbfsValidator validator = GbfsValidatorFactory.getGbfsJsonValidator();
        return validator.validate(feeds);
    }
}

