/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.loader.v3;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.entur.gbfs.authentication.RequestAuthenticator;
import org.entur.gbfs.loader.BaseGbfsLoader;
import org.entur.gbfs.loader.GbfsFeed;
import org.entur.gbfs.v3_0.gbfs.GBFSFeed;
import org.entur.gbfs.v3_0.gbfs.GBFSFeedName;
import org.entur.gbfs.v3_0.gbfs.GBFSGbfs;

public class GbfsV3Loader
extends BaseGbfsLoader<GBFSFeed.Name, GBFSGbfs> {
    public GbfsV3Loader(String url) {
        this(url, new HashMap<String, String>());
    }

    public GbfsV3Loader(String url, Map<String, String> httpHeaders) {
        this(url, httpHeaders, null, null);
    }

    public GbfsV3Loader(String url, RequestAuthenticator requestAuthenticator) {
        this(url, new HashMap<String, String>(), requestAuthenticator, null);
    }

    public GbfsV3Loader(String url, RequestAuthenticator requestAuthenticator, Long timeoutConnection) {
        this(url, new HashMap<String, String>(), requestAuthenticator, timeoutConnection);
    }

    public GbfsV3Loader(String url, Map<String, String> httpHeaders, RequestAuthenticator requestAuthenticator, Long timeoutConnection) {
        super(url, httpHeaders, requestAuthenticator, timeoutConnection, GBFSGbfs.class);
        this.init();
    }

    @Override
    protected List<GbfsFeed<GBFSFeed.Name, ?>> getFeeds() {
        List feeds = ((GBFSGbfs)this.getDiscoveryFeed()).getData().getFeeds();
        return feeds.stream().map(feed -> new GbfsFeed(feed.getName(), GBFSFeedName.implementingClass((GBFSFeed.Name)feed.getName()), URI.create(feed.getUrl()))).collect(Collectors.toList());
    }

    @Override
    protected GBFSFeed.Name getDiscoveryFeedName() {
        return GBFSFeed.Name.GBFS;
    }
}

